/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MergeDeveloperIdentitiesRequest
extends CognitoIdentityRequest
implements ToCopyableBuilder<Builder, MergeDeveloperIdentitiesRequest> {
    private final String sourceUserIdentifier;
    private final String destinationUserIdentifier;
    private final String developerProviderName;
    private final String identityPoolId;

    private MergeDeveloperIdentitiesRequest(BuilderImpl builder) {
        super(builder);
        this.sourceUserIdentifier = builder.sourceUserIdentifier;
        this.destinationUserIdentifier = builder.destinationUserIdentifier;
        this.developerProviderName = builder.developerProviderName;
        this.identityPoolId = builder.identityPoolId;
    }

    public String sourceUserIdentifier() {
        return this.sourceUserIdentifier;
    }

    public String destinationUserIdentifier() {
        return this.destinationUserIdentifier;
    }

    public String developerProviderName() {
        return this.developerProviderName;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceUserIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationUserIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.developerProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeDeveloperIdentitiesRequest)) {
            return false;
        }
        MergeDeveloperIdentitiesRequest other = (MergeDeveloperIdentitiesRequest)((Object)obj);
        return Objects.equals(this.sourceUserIdentifier(), other.sourceUserIdentifier()) && Objects.equals(this.destinationUserIdentifier(), other.destinationUserIdentifier()) && Objects.equals(this.developerProviderName(), other.developerProviderName()) && Objects.equals(this.identityPoolId(), other.identityPoolId());
    }

    public String toString() {
        return ToString.builder((String)"MergeDeveloperIdentitiesRequest").add("SourceUserIdentifier", (Object)this.sourceUserIdentifier()).add("DestinationUserIdentifier", (Object)this.destinationUserIdentifier()).add("DeveloperProviderName", (Object)this.developerProviderName()).add("IdentityPoolId", (Object)this.identityPoolId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceUserIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceUserIdentifier()));
            }
            case "DestinationUserIdentifier": {
                return Optional.ofNullable(clazz.cast(this.destinationUserIdentifier()));
            }
            case "DeveloperProviderName": {
                return Optional.ofNullable(clazz.cast(this.developerProviderName()));
            }
            case "IdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.identityPoolId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityRequest.BuilderImpl
    implements Builder {
        private String sourceUserIdentifier;
        private String destinationUserIdentifier;
        private String developerProviderName;
        private String identityPoolId;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeDeveloperIdentitiesRequest model) {
            super(model);
            this.sourceUserIdentifier(model.sourceUserIdentifier);
            this.destinationUserIdentifier(model.destinationUserIdentifier);
            this.developerProviderName(model.developerProviderName);
            this.identityPoolId(model.identityPoolId);
        }

        public final String getSourceUserIdentifier() {
            return this.sourceUserIdentifier;
        }

        @Override
        public final Builder sourceUserIdentifier(String sourceUserIdentifier) {
            this.sourceUserIdentifier = sourceUserIdentifier;
            return this;
        }

        public final void setSourceUserIdentifier(String sourceUserIdentifier) {
            this.sourceUserIdentifier = sourceUserIdentifier;
        }

        public final String getDestinationUserIdentifier() {
            return this.destinationUserIdentifier;
        }

        @Override
        public final Builder destinationUserIdentifier(String destinationUserIdentifier) {
            this.destinationUserIdentifier = destinationUserIdentifier;
            return this;
        }

        public final void setDestinationUserIdentifier(String destinationUserIdentifier) {
            this.destinationUserIdentifier = destinationUserIdentifier;
        }

        public final String getDeveloperProviderName() {
            return this.developerProviderName;
        }

        @Override
        public final Builder developerProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
            return this;
        }

        public final void setDeveloperProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MergeDeveloperIdentitiesRequest build() {
            return new MergeDeveloperIdentitiesRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityRequest.Builder,
    CopyableBuilder<Builder, MergeDeveloperIdentitiesRequest> {
        public Builder sourceUserIdentifier(String var1);

        public Builder destinationUserIdentifier(String var1);

        public Builder developerProviderName(String var1);

        public Builder identityPoolId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

