/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cognitoidentity.model.MappingRule;

public class MappingRuleUnmarshaller
implements Unmarshaller<MappingRule, JsonUnmarshallerContext> {
    private static final MappingRuleUnmarshaller INSTANCE = new MappingRuleUnmarshaller();

    public MappingRule unmarshall(JsonUnmarshallerContext context) throws Exception {
        MappingRule.Builder mappingRuleBuilder = MappingRule.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Claim", targetDepth)) {
                    context.nextToken();
                    mappingRuleBuilder.claim((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("MatchType", targetDepth)) {
                    context.nextToken();
                    mappingRuleBuilder.matchType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Value", targetDepth)) {
                    context.nextToken();
                    mappingRuleBuilder.value((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RoleARN", targetDepth)) {
                    context.nextToken();
                    mappingRuleBuilder.roleARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (MappingRule)mappingRuleBuilder.build();
    }

    public static MappingRuleUnmarshaller getInstance() {
        return INSTANCE;
    }
}

