/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to the <code>GetOpenIdTokenForDeveloperIdentity</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetOpenIdTokenForDeveloperIdentityRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetOpenIdTokenForDeveloperIdentityRequest.Builder, GetOpenIdTokenForDeveloperIdentityRequest> {
    private final String identityPoolId;

    private final String identityId;

    private final Map<String, String> logins;

    private final Long tokenDuration;

    private GetOpenIdTokenForDeveloperIdentityRequest(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.identityId = builder.identityId;
        this.logins = builder.logins;
        this.tokenDuration = builder.tokenDuration;
    }

    /**
     * <p>
     * An identity pool ID in the format REGION:GUID.
     * </p>
     * 
     * @return An identity pool ID in the format REGION:GUID.
     */
    public String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * A unique identifier in the format REGION:GUID.
     * </p>
     * 
     * @return A unique identifier in the format REGION:GUID.
     */
    public String identityId() {
        return identityId;
    }

    /**
     * <p>
     * A set of optional name-value pairs that map provider names to provider tokens. Each name-value pair represents a
     * user from a public provider or developer provider. If the user is from a developer provider, the name-value pair
     * will follow the syntax <code>"developer_provider_name": "developer_user_identifier"</code>. The developer
     * provider is the "domain" by which Cognito will refer to your users; you provided this domain while
     * creating/updating the identity pool. The developer user identifier is an identifier from your backend that
     * uniquely identifies a user. When you create an identity pool, you can specify the supported logins.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A set of optional name-value pairs that map provider names to provider tokens. Each name-value pair
     *         represents a user from a public provider or developer provider. If the user is from a developer provider,
     *         the name-value pair will follow the syntax
     *         <code>"developer_provider_name": "developer_user_identifier"</code>. The developer provider is the
     *         "domain" by which Cognito will refer to your users; you provided this domain while creating/updating the
     *         identity pool. The developer user identifier is an identifier from your backend that uniquely identifies
     *         a user. When you create an identity pool, you can specify the supported logins.
     */
    public Map<String, String> logins() {
        return logins;
    }

    /**
     * <p>
     * The expiration time of the token, in seconds. You can specify a custom expiration time for the token so that you
     * can cache it. If you don't provide an expiration time, the token is valid for 15 minutes. You can exchange the
     * token with Amazon STS for temporary AWS credentials, which are valid for a maximum of one hour. The maximum token
     * duration you can set is 24 hours. You should take care in setting the expiration time for a token, as there are
     * significant security implications: an attacker could use a leaked token to access your AWS resources for the
     * token's duration.
     * </p>
     * 
     * @return The expiration time of the token, in seconds. You can specify a custom expiration time for the token so
     *         that you can cache it. If you don't provide an expiration time, the token is valid for 15 minutes. You
     *         can exchange the token with Amazon STS for temporary AWS credentials, which are valid for a maximum of
     *         one hour. The maximum token duration you can set is 24 hours. You should take care in setting the
     *         expiration time for a token, as there are significant security implications: an attacker could use a
     *         leaked token to access your AWS resources for the token's duration.
     */
    public Long tokenDuration() {
        return tokenDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((identityPoolId() == null) ? 0 : identityPoolId().hashCode());
        hashCode = 31 * hashCode + ((identityId() == null) ? 0 : identityId().hashCode());
        hashCode = 31 * hashCode + ((logins() == null) ? 0 : logins().hashCode());
        hashCode = 31 * hashCode + ((tokenDuration() == null) ? 0 : tokenDuration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpenIdTokenForDeveloperIdentityRequest)) {
            return false;
        }
        GetOpenIdTokenForDeveloperIdentityRequest other = (GetOpenIdTokenForDeveloperIdentityRequest) obj;
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        if (other.identityPoolId() != null && !other.identityPoolId().equals(this.identityPoolId())) {
            return false;
        }
        if (other.identityId() == null ^ this.identityId() == null) {
            return false;
        }
        if (other.identityId() != null && !other.identityId().equals(this.identityId())) {
            return false;
        }
        if (other.logins() == null ^ this.logins() == null) {
            return false;
        }
        if (other.logins() != null && !other.logins().equals(this.logins())) {
            return false;
        }
        if (other.tokenDuration() == null ^ this.tokenDuration() == null) {
            return false;
        }
        if (other.tokenDuration() != null && !other.tokenDuration().equals(this.tokenDuration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(identityPoolId()).append(",");
        }
        if (identityId() != null) {
            sb.append("IdentityId: ").append(identityId()).append(",");
        }
        if (logins() != null) {
            sb.append("Logins: ").append(logins()).append(",");
        }
        if (tokenDuration() != null) {
            sb.append("TokenDuration: ").append(tokenDuration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetOpenIdTokenForDeveloperIdentityRequest> {
        /**
         * <p>
         * An identity pool ID in the format REGION:GUID.
         * </p>
         * 
         * @param identityPoolId
         *        An identity pool ID in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * A unique identifier in the format REGION:GUID.
         * </p>
         * 
         * @param identityId
         *        A unique identifier in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * A set of optional name-value pairs that map provider names to provider tokens. Each name-value pair
         * represents a user from a public provider or developer provider. If the user is from a developer provider, the
         * name-value pair will follow the syntax <code>"developer_provider_name": "developer_user_identifier"</code>.
         * The developer provider is the "domain" by which Cognito will refer to your users; you provided this domain
         * while creating/updating the identity pool. The developer user identifier is an identifier from your backend
         * that uniquely identifies a user. When you create an identity pool, you can specify the supported logins.
         * </p>
         * 
         * @param logins
         *        A set of optional name-value pairs that map provider names to provider tokens. Each name-value pair
         *        represents a user from a public provider or developer provider. If the user is from a developer
         *        provider, the name-value pair will follow the syntax
         *        <code>"developer_provider_name": "developer_user_identifier"</code>. The developer provider is the
         *        "domain" by which Cognito will refer to your users; you provided this domain while creating/updating
         *        the identity pool. The developer user identifier is an identifier from your backend that uniquely
         *        identifies a user. When you create an identity pool, you can specify the supported logins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logins(Map<String, String> logins);

        /**
         * <p>
         * The expiration time of the token, in seconds. You can specify a custom expiration time for the token so that
         * you can cache it. If you don't provide an expiration time, the token is valid for 15 minutes. You can
         * exchange the token with Amazon STS for temporary AWS credentials, which are valid for a maximum of one hour.
         * The maximum token duration you can set is 24 hours. You should take care in setting the expiration time for a
         * token, as there are significant security implications: an attacker could use a leaked token to access your
         * AWS resources for the token's duration.
         * </p>
         * 
         * @param tokenDuration
         *        The expiration time of the token, in seconds. You can specify a custom expiration time for the token
         *        so that you can cache it. If you don't provide an expiration time, the token is valid for 15 minutes.
         *        You can exchange the token with Amazon STS for temporary AWS credentials, which are valid for a
         *        maximum of one hour. The maximum token duration you can set is 24 hours. You should take care in
         *        setting the expiration time for a token, as there are significant security implications: an attacker
         *        could use a leaked token to access your AWS resources for the token's duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenDuration(Long tokenDuration);
    }

    private static final class BuilderImpl implements Builder {
        private String identityPoolId;

        private String identityId;

        private Map<String, String> logins;

        private Long tokenDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpenIdTokenForDeveloperIdentityRequest model) {
            setIdentityPoolId(model.identityPoolId);
            setIdentityId(model.identityId);
            setLogins(model.logins);
            setTokenDuration(model.tokenDuration);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getIdentityId() {
            return identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final Map<String, String> getLogins() {
            return logins;
        }

        @Override
        public final Builder logins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
            return this;
        }

        public final void setLogins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
        }

        public final Long getTokenDuration() {
            return tokenDuration;
        }

        @Override
        public final Builder tokenDuration(Long tokenDuration) {
            this.tokenDuration = tokenDuration;
            return this;
        }

        public final void setTokenDuration(Long tokenDuration) {
            this.tokenDuration = tokenDuration;
        }

        @Override
        public GetOpenIdTokenForDeveloperIdentityRequest build() {
            return new GetOpenIdTokenForDeveloperIdentityRequest(this);
        }
    }
}
