/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to the ListIdentities action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListIdentitiesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListIdentitiesRequest.Builder, ListIdentitiesRequest> {
    private final String identityPoolId;

    private final Integer maxResults;

    private final String nextToken;

    private final Boolean hideDisabled;

    private ListIdentitiesRequest(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.hideDisabled = builder.hideDisabled;
    }

    /**
     * <p>
     * An identity pool ID in the format REGION:GUID.
     * </p>
     * 
     * @return An identity pool ID in the format REGION:GUID.
     */
    public String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * The maximum number of identities to return.
     * </p>
     * 
     * @return The maximum number of identities to return.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A pagination token.
     * </p>
     * 
     * @return A pagination token.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * An optional boolean parameter that allows you to hide disabled identities. If omitted, the ListIdentities API
     * will include disabled identities in the response.
     * </p>
     * 
     * @return An optional boolean parameter that allows you to hide disabled identities. If omitted, the ListIdentities
     *         API will include disabled identities in the response.
     */
    public Boolean hideDisabled() {
        return hideDisabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((identityPoolId() == null) ? 0 : identityPoolId().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((hideDisabled() == null) ? 0 : hideDisabled().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentitiesRequest)) {
            return false;
        }
        ListIdentitiesRequest other = (ListIdentitiesRequest) obj;
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        if (other.identityPoolId() != null && !other.identityPoolId().equals(this.identityPoolId())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.hideDisabled() == null ^ this.hideDisabled() == null) {
            return false;
        }
        if (other.hideDisabled() != null && !other.hideDisabled().equals(this.hideDisabled())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(identityPoolId()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (hideDisabled() != null) {
            sb.append("HideDisabled: ").append(hideDisabled()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListIdentitiesRequest> {
        /**
         * <p>
         * An identity pool ID in the format REGION:GUID.
         * </p>
         * 
         * @param identityPoolId
         *        An identity pool ID in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * The maximum number of identities to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of identities to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A pagination token.
         * </p>
         * 
         * @param nextToken
         *        A pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An optional boolean parameter that allows you to hide disabled identities. If omitted, the ListIdentities API
         * will include disabled identities in the response.
         * </p>
         * 
         * @param hideDisabled
         *        An optional boolean parameter that allows you to hide disabled identities. If omitted, the
         *        ListIdentities API will include disabled identities in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hideDisabled(Boolean hideDisabled);
    }

    private static final class BuilderImpl implements Builder {
        private String identityPoolId;

        private Integer maxResults;

        private String nextToken;

        private Boolean hideDisabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentitiesRequest model) {
            setIdentityPoolId(model.identityPoolId);
            setMaxResults(model.maxResults);
            setNextToken(model.nextToken);
            setHideDisabled(model.hideDisabled);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Boolean getHideDisabled() {
            return hideDisabled;
        }

        @Override
        public final Builder hideDisabled(Boolean hideDisabled) {
            this.hideDisabled = hideDisabled;
            return this;
        }

        public final void setHideDisabled(Boolean hideDisabled) {
            this.hideDisabled = hideDisabled;
        }

        @Override
        public ListIdentitiesRequest build() {
            return new ListIdentitiesRequest(this);
        }
    }
}
