/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.transform.IdentityPoolShortDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A description of the identity pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class IdentityPoolShortDescription implements StructuredPojo,
        ToCopyableBuilder<IdentityPoolShortDescription.Builder, IdentityPoolShortDescription> {
    private final String identityPoolId;

    private final String identityPoolName;

    private IdentityPoolShortDescription(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.identityPoolName = builder.identityPoolName;
    }

    /**
     * <p>
     * An identity pool ID in the format REGION:GUID.
     * </p>
     * 
     * @return An identity pool ID in the format REGION:GUID.
     */
    public String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * A string that you provide.
     * </p>
     * 
     * @return A string that you provide.
     */
    public String identityPoolName() {
        return identityPoolName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((identityPoolId() == null) ? 0 : identityPoolId().hashCode());
        hashCode = 31 * hashCode + ((identityPoolName() == null) ? 0 : identityPoolName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityPoolShortDescription)) {
            return false;
        }
        IdentityPoolShortDescription other = (IdentityPoolShortDescription) obj;
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        if (other.identityPoolId() != null && !other.identityPoolId().equals(this.identityPoolId())) {
            return false;
        }
        if (other.identityPoolName() == null ^ this.identityPoolName() == null) {
            return false;
        }
        if (other.identityPoolName() != null && !other.identityPoolName().equals(this.identityPoolName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(identityPoolId()).append(",");
        }
        if (identityPoolName() != null) {
            sb.append("IdentityPoolName: ").append(identityPoolName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IdentityPoolShortDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, IdentityPoolShortDescription> {
        /**
         * <p>
         * An identity pool ID in the format REGION:GUID.
         * </p>
         * 
         * @param identityPoolId
         *        An identity pool ID in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * A string that you provide.
         * </p>
         * 
         * @param identityPoolName
         *        A string that you provide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolName(String identityPoolName);
    }

    private static final class BuilderImpl implements Builder {
        private String identityPoolId;

        private String identityPoolName;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityPoolShortDescription model) {
            setIdentityPoolId(model.identityPoolId);
            setIdentityPoolName(model.identityPoolName);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getIdentityPoolName() {
            return identityPoolName;
        }

        @Override
        public final Builder identityPoolName(String identityPoolName) {
            this.identityPoolName = identityPoolName;
            return this;
        }

        public final void setIdentityPoolName(String identityPoolName) {
            this.identityPoolName = identityPoolName;
        }

        @Override
        public IdentityPoolShortDescription build() {
            return new IdentityPoolShortDescription(this);
        }
    }
}
