/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returned in response to a successful <code>GetOpenIdTokenForDeveloperIdentity</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetOpenIdTokenForDeveloperIdentityResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetOpenIdTokenForDeveloperIdentityResponse.Builder, GetOpenIdTokenForDeveloperIdentityResponse> {
    private final String identityId;

    private final String token;

    private GetOpenIdTokenForDeveloperIdentityResponse(BuilderImpl builder) {
        this.identityId = builder.identityId;
        this.token = builder.token;
    }

    /**
     * <p>
     * A unique identifier in the format REGION:GUID.
     * </p>
     * 
     * @return A unique identifier in the format REGION:GUID.
     */
    public String identityId() {
        return identityId;
    }

    /**
     * <p>
     * An OpenID token.
     * </p>
     * 
     * @return An OpenID token.
     */
    public String token() {
        return token;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((identityId() == null) ? 0 : identityId().hashCode());
        hashCode = 31 * hashCode + ((token() == null) ? 0 : token().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpenIdTokenForDeveloperIdentityResponse)) {
            return false;
        }
        GetOpenIdTokenForDeveloperIdentityResponse other = (GetOpenIdTokenForDeveloperIdentityResponse) obj;
        if (other.identityId() == null ^ this.identityId() == null) {
            return false;
        }
        if (other.identityId() != null && !other.identityId().equals(this.identityId())) {
            return false;
        }
        if (other.token() == null ^ this.token() == null) {
            return false;
        }
        if (other.token() != null && !other.token().equals(this.token())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (identityId() != null) {
            sb.append("IdentityId: ").append(identityId()).append(",");
        }
        if (token() != null) {
            sb.append("Token: ").append(token()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetOpenIdTokenForDeveloperIdentityResponse> {
        /**
         * <p>
         * A unique identifier in the format REGION:GUID.
         * </p>
         * 
         * @param identityId
         *        A unique identifier in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * An OpenID token.
         * </p>
         * 
         * @param token
         *        An OpenID token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);
    }

    private static final class BuilderImpl implements Builder {
        private String identityId;

        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpenIdTokenForDeveloperIdentityResponse model) {
            setIdentityId(model.identityId);
            setToken(model.token);
        }

        public final String getIdentityId() {
            return identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getToken() {
            return token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public GetOpenIdTokenForDeveloperIdentityResponse build() {
            return new GetOpenIdTokenForDeveloperIdentityResponse(this);
        }
    }
}
