/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.transform;

import java.util.Map;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.cognitoidentity.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * GetOpenIdTokenForDeveloperIdentityRequestMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class GetOpenIdTokenForDeveloperIdentityRequestModelMarshaller {

    private static final MarshallingInfo<String> IDENTITYPOOLID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityPoolId").build();
    private static final MarshallingInfo<String> IDENTITYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityId").build();
    private static final MarshallingInfo<Map> LOGINS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Logins").build();
    private static final MarshallingInfo<Long> TOKENDURATION_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TokenDuration").build();

    private static final GetOpenIdTokenForDeveloperIdentityRequestModelMarshaller INSTANCE = new GetOpenIdTokenForDeveloperIdentityRequestModelMarshaller();

    public static GetOpenIdTokenForDeveloperIdentityRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(GetOpenIdTokenForDeveloperIdentityRequest getOpenIdTokenForDeveloperIdentityRequest,
            ProtocolMarshaller protocolMarshaller) {

        if (getOpenIdTokenForDeveloperIdentityRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(getOpenIdTokenForDeveloperIdentityRequest.identityPoolId(), IDENTITYPOOLID_BINDING);

            protocolMarshaller.marshall(getOpenIdTokenForDeveloperIdentityRequest.identityId(), IDENTITYID_BINDING);

            protocolMarshaller.marshall(getOpenIdTokenForDeveloperIdentityRequest.logins(), LOGINS_BINDING);

            protocolMarshaller.marshall(getOpenIdTokenForDeveloperIdentityRequest.tokenDuration(), TOKENDURATION_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
