/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cognitoidentity.model.IdentityIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteIdentitiesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteIdentitiesRequest> {
    private final List<String> identityIdsToDelete;

    private DeleteIdentitiesRequest(BuilderImpl builder) {
        this.identityIdsToDelete = builder.identityIdsToDelete;
    }

    public List<String> identityIdsToDelete() {
        return this.identityIdsToDelete;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityIdsToDelete() == null ? 0 : this.identityIdsToDelete().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIdentitiesRequest)) {
            return false;
        }
        DeleteIdentitiesRequest other = (DeleteIdentitiesRequest)((Object)obj);
        if (other.identityIdsToDelete() == null ^ this.identityIdsToDelete() == null) {
            return false;
        }
        return other.identityIdsToDelete() == null || other.identityIdsToDelete().equals(this.identityIdsToDelete());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identityIdsToDelete() != null) {
            sb.append("IdentityIdsToDelete: ").append(this.identityIdsToDelete()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityIdsToDelete": {
                return Optional.of(clazz.cast(this.identityIdsToDelete()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> identityIdsToDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIdentitiesRequest model) {
            this.identityIdsToDelete(model.identityIdsToDelete);
        }

        public final Collection<String> getIdentityIdsToDelete() {
            return this.identityIdsToDelete;
        }

        @Override
        public final Builder identityIdsToDelete(Collection<String> identityIdsToDelete) {
            this.identityIdsToDelete = IdentityIdListCopier.copy(identityIdsToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityIdsToDelete(String ... identityIdsToDelete) {
            this.identityIdsToDelete(Arrays.asList(identityIdsToDelete));
            return this;
        }

        public final void setIdentityIdsToDelete(Collection<String> identityIdsToDelete) {
            this.identityIdsToDelete = IdentityIdListCopier.copy(identityIdsToDelete);
        }

        public DeleteIdentitiesRequest build() {
            return new DeleteIdentitiesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteIdentitiesRequest> {
        public Builder identityIdsToDelete(Collection<String> var1);

        public Builder identityIdsToDelete(String ... var1);
    }
}

