/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.cognitoidentity.model.IdentityPoolShortDescription;
import software.amazon.awssdk.services.cognitoidentity.model.IdentityPoolsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListIdentityPoolsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListIdentityPoolsResponse> {
    private final List<IdentityPoolShortDescription> identityPools;
    private final String nextToken;

    private ListIdentityPoolsResponse(BuilderImpl builder) {
        this.identityPools = builder.identityPools;
        this.nextToken = builder.nextToken;
    }

    public List<IdentityPoolShortDescription> identityPools() {
        return this.identityPools;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityPools() == null ? 0 : this.identityPools().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityPoolsResponse)) {
            return false;
        }
        ListIdentityPoolsResponse other = (ListIdentityPoolsResponse)((Object)obj);
        if (other.identityPools() == null ^ this.identityPools() == null) {
            return false;
        }
        if (other.identityPools() != null && !other.identityPools().equals(this.identityPools())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identityPools() != null) {
            sb.append("IdentityPools: ").append(this.identityPools()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPools": {
                return Optional.of(clazz.cast(this.identityPools()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<IdentityPoolShortDescription> identityPools;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityPoolsResponse model) {
            this.identityPools(model.identityPools);
            this.nextToken(model.nextToken);
        }

        public final Collection<IdentityPoolShortDescription.Builder> getIdentityPools() {
            return this.identityPools != null ? (Collection)this.identityPools.stream().map(IdentityPoolShortDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder identityPools(Collection<IdentityPoolShortDescription> identityPools) {
            this.identityPools = IdentityPoolsListCopier.copy(identityPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityPools(IdentityPoolShortDescription ... identityPools) {
            this.identityPools(Arrays.asList(identityPools));
            return this;
        }

        public final void setIdentityPools(Collection<IdentityPoolShortDescription.BuilderImpl> identityPools) {
            this.identityPools = IdentityPoolsListCopier.copyFromBuilder(identityPools);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListIdentityPoolsResponse build() {
            return new ListIdentityPoolsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListIdentityPoolsResponse> {
        public Builder identityPools(Collection<IdentityPoolShortDescription> var1);

        public Builder identityPools(IdentityPoolShortDescription ... var1);

        public Builder nextToken(String var1);
    }
}

