/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.model.AmbiguousRoleResolutionType;
import software.amazon.awssdk.services.cognitoidentity.model.RoleMappingType;
import software.amazon.awssdk.services.cognitoidentity.model.RulesConfigurationType;
import software.amazon.awssdk.services.cognitoidentity.transform.RoleMappingMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RoleMapping
implements StructuredPojo,
ToCopyableBuilder<Builder, RoleMapping> {
    private final String type;
    private final String ambiguousRoleResolution;
    private final RulesConfigurationType rulesConfiguration;

    private RoleMapping(BuilderImpl builder) {
        this.type = builder.type;
        this.ambiguousRoleResolution = builder.ambiguousRoleResolution;
        this.rulesConfiguration = builder.rulesConfiguration;
    }

    public RoleMappingType type() {
        return RoleMappingType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public AmbiguousRoleResolutionType ambiguousRoleResolution() {
        return AmbiguousRoleResolutionType.fromValue(this.ambiguousRoleResolution);
    }

    public String ambiguousRoleResolutionString() {
        return this.ambiguousRoleResolution;
    }

    public RulesConfigurationType rulesConfiguration() {
        return this.rulesConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.typeString() == null ? 0 : this.typeString().hashCode());
        hashCode = 31 * hashCode + (this.ambiguousRoleResolutionString() == null ? 0 : this.ambiguousRoleResolutionString().hashCode());
        hashCode = 31 * hashCode + (this.rulesConfiguration() == null ? 0 : this.rulesConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleMapping)) {
            return false;
        }
        RoleMapping other = (RoleMapping)obj;
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.ambiguousRoleResolutionString() == null ^ this.ambiguousRoleResolutionString() == null) {
            return false;
        }
        if (other.ambiguousRoleResolutionString() != null && !other.ambiguousRoleResolutionString().equals(this.ambiguousRoleResolutionString())) {
            return false;
        }
        if (other.rulesConfiguration() == null ^ this.rulesConfiguration() == null) {
            return false;
        }
        return other.rulesConfiguration() == null || other.rulesConfiguration().equals(this.rulesConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.ambiguousRoleResolutionString() != null) {
            sb.append("AmbiguousRoleResolution: ").append(this.ambiguousRoleResolutionString()).append(",");
        }
        if (this.rulesConfiguration() != null) {
            sb.append("RulesConfiguration: ").append(this.rulesConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "AmbiguousRoleResolution": {
                return Optional.of(clazz.cast(this.ambiguousRoleResolutionString()));
            }
            case "RulesConfiguration": {
                return Optional.of(clazz.cast(this.rulesConfiguration()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RoleMappingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String ambiguousRoleResolution;
        private RulesConfigurationType rulesConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RoleMapping model) {
            this.type(model.type);
            this.ambiguousRoleResolution(model.ambiguousRoleResolution);
            this.rulesConfiguration(model.rulesConfiguration);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RoleMappingType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getAmbiguousRoleResolution() {
            return this.ambiguousRoleResolution;
        }

        @Override
        public final Builder ambiguousRoleResolution(String ambiguousRoleResolution) {
            this.ambiguousRoleResolution = ambiguousRoleResolution;
            return this;
        }

        @Override
        public final Builder ambiguousRoleResolution(AmbiguousRoleResolutionType ambiguousRoleResolution) {
            this.ambiguousRoleResolution(ambiguousRoleResolution.toString());
            return this;
        }

        public final void setAmbiguousRoleResolution(String ambiguousRoleResolution) {
            this.ambiguousRoleResolution = ambiguousRoleResolution;
        }

        public final RulesConfigurationType.Builder getRulesConfiguration() {
            return this.rulesConfiguration != null ? this.rulesConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder rulesConfiguration(RulesConfigurationType rulesConfiguration) {
            this.rulesConfiguration = rulesConfiguration;
            return this;
        }

        public final void setRulesConfiguration(RulesConfigurationType.BuilderImpl rulesConfiguration) {
            this.rulesConfiguration = rulesConfiguration != null ? rulesConfiguration.build() : null;
        }

        public RoleMapping build() {
            return new RoleMapping(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RoleMapping> {
        public Builder type(String var1);

        public Builder type(RoleMappingType var1);

        public Builder ambiguousRoleResolution(String var1);

        public Builder ambiguousRoleResolution(AmbiguousRoleResolutionType var1);

        public Builder rulesConfiguration(RulesConfigurationType var1);
    }
}

