/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentity.model.CreateIdentityPoolRequest;

@SdkInternalApi
public class CreateIdentityPoolRequestModelMarshaller {
    private static final MarshallingInfo<String> IDENTITYPOOLNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityPoolName").build();
    private static final MarshallingInfo<Boolean> ALLOWUNAUTHENTICATEDIDENTITIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowUnauthenticatedIdentities").build();
    private static final MarshallingInfo<Map> SUPPORTEDLOGINPROVIDERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedLoginProviders").build();
    private static final MarshallingInfo<String> DEVELOPERPROVIDERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeveloperProviderName").build();
    private static final MarshallingInfo<List> OPENIDCONNECTPROVIDERARNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OpenIdConnectProviderARNs").build();
    private static final MarshallingInfo<List> COGNITOIDENTITYPROVIDERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CognitoIdentityProviders").build();
    private static final MarshallingInfo<List> SAMLPROVIDERARNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SamlProviderARNs").build();
    private static final CreateIdentityPoolRequestModelMarshaller INSTANCE = new CreateIdentityPoolRequestModelMarshaller();

    public static CreateIdentityPoolRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateIdentityPoolRequest createIdentityPoolRequest, ProtocolMarshaller protocolMarshaller) {
        if (createIdentityPoolRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createIdentityPoolRequest.identityPoolName(), IDENTITYPOOLNAME_BINDING);
            protocolMarshaller.marshall((Object)createIdentityPoolRequest.allowUnauthenticatedIdentities(), ALLOWUNAUTHENTICATEDIDENTITIES_BINDING);
            protocolMarshaller.marshall(createIdentityPoolRequest.supportedLoginProviders(), SUPPORTEDLOGINPROVIDERS_BINDING);
            protocolMarshaller.marshall((Object)createIdentityPoolRequest.developerProviderName(), DEVELOPERPROVIDERNAME_BINDING);
            protocolMarshaller.marshall(createIdentityPoolRequest.openIdConnectProviderARNs(), OPENIDCONNECTPROVIDERARNS_BINDING);
            protocolMarshaller.marshall(createIdentityPoolRequest.cognitoIdentityProviders(), COGNITOIDENTITYPROVIDERS_BINDING);
            protocolMarshaller.marshall(createIdentityPoolRequest.samlProviderARNs(), SAMLPROVIDERARNS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

