/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.transform.CredentialsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Credentials for the provided identity ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Credentials implements StructuredPojo, ToCopyableBuilder<Credentials.Builder, Credentials> {
    private final String accessKeyId;

    private final String secretKey;

    private final String sessionToken;

    private final Instant expiration;

    private Credentials(BuilderImpl builder) {
        this.accessKeyId = builder.accessKeyId;
        this.secretKey = builder.secretKey;
        this.sessionToken = builder.sessionToken;
        this.expiration = builder.expiration;
    }

    /**
     * <p>
     * The Access Key portion of the credentials.
     * </p>
     * 
     * @return The Access Key portion of the credentials.
     */
    public String accessKeyId() {
        return accessKeyId;
    }

    /**
     * <p>
     * The Secret Access Key portion of the credentials
     * </p>
     * 
     * @return The Secret Access Key portion of the credentials
     */
    public String secretKey() {
        return secretKey;
    }

    /**
     * <p>
     * The Session Token portion of the credentials
     * </p>
     * 
     * @return The Session Token portion of the credentials
     */
    public String sessionToken() {
        return sessionToken;
    }

    /**
     * <p>
     * The date at which these credentials will expire.
     * </p>
     * 
     * @return The date at which these credentials will expire.
     */
    public Instant expiration() {
        return expiration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(secretKey());
        hashCode = 31 * hashCode + Objects.hashCode(sessionToken());
        hashCode = 31 * hashCode + Objects.hashCode(expiration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Credentials)) {
            return false;
        }
        Credentials other = (Credentials) obj;
        return Objects.equals(accessKeyId(), other.accessKeyId()) && Objects.equals(secretKey(), other.secretKey())
                && Objects.equals(sessionToken(), other.sessionToken()) && Objects.equals(expiration(), other.expiration());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (accessKeyId() != null) {
            sb.append("AccessKeyId: ").append(accessKeyId()).append(",");
        }
        if (secretKey() != null) {
            sb.append("SecretKey: ").append(secretKey()).append(",");
        }
        if (sessionToken() != null) {
            sb.append("SessionToken: ").append(sessionToken()).append(",");
        }
        if (expiration() != null) {
            sb.append("Expiration: ").append(expiration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessKeyId":
            return Optional.of(clazz.cast(accessKeyId()));
        case "SecretKey":
            return Optional.of(clazz.cast(secretKey()));
        case "SessionToken":
            return Optional.of(clazz.cast(sessionToken()));
        case "Expiration":
            return Optional.of(clazz.cast(expiration()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CredentialsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Credentials> {
        /**
         * <p>
         * The Access Key portion of the credentials.
         * </p>
         * 
         * @param accessKeyId
         *        The Access Key portion of the credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKeyId(String accessKeyId);

        /**
         * <p>
         * The Secret Access Key portion of the credentials
         * </p>
         * 
         * @param secretKey
         *        The Secret Access Key portion of the credentials
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretKey(String secretKey);

        /**
         * <p>
         * The Session Token portion of the credentials
         * </p>
         * 
         * @param sessionToken
         *        The Session Token portion of the credentials
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionToken(String sessionToken);

        /**
         * <p>
         * The date at which these credentials will expire.
         * </p>
         * 
         * @param expiration
         *        The date at which these credentials will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(Instant expiration);
    }

    static final class BuilderImpl implements Builder {
        private String accessKeyId;

        private String secretKey;

        private String sessionToken;

        private Instant expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(Credentials model) {
            accessKeyId(model.accessKeyId);
            secretKey(model.secretKey);
            sessionToken(model.sessionToken);
            expiration(model.expiration);
        }

        public final String getAccessKeyId() {
            return accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        public final String getSecretKey() {
            return secretKey;
        }

        @Override
        public final Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public final void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public final String getSessionToken() {
            return sessionToken;
        }

        @Override
        public final Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public final void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        public final Instant getExpiration() {
            return expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        @Override
        public Credentials build() {
            return new Credentials(this);
        }
    }
}
