/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to the <code>DeleteIdentities</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteIdentitiesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteIdentitiesRequest.Builder, DeleteIdentitiesRequest> {
    private final List<String> identityIdsToDelete;

    private DeleteIdentitiesRequest(BuilderImpl builder) {
        this.identityIdsToDelete = builder.identityIdsToDelete;
    }

    /**
     * <p>
     * A list of 1-60 identities that you want to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of 1-60 identities that you want to delete.
     */
    public List<String> identityIdsToDelete() {
        return identityIdsToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityIdsToDelete());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIdentitiesRequest)) {
            return false;
        }
        DeleteIdentitiesRequest other = (DeleteIdentitiesRequest) obj;
        return Objects.equals(identityIdsToDelete(), other.identityIdsToDelete());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (identityIdsToDelete() != null) {
            sb.append("IdentityIdsToDelete: ").append(identityIdsToDelete()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityIdsToDelete":
            return Optional.of(clazz.cast(identityIdsToDelete()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteIdentitiesRequest> {
        /**
         * <p>
         * A list of 1-60 identities that you want to delete.
         * </p>
         * 
         * @param identityIdsToDelete
         *        A list of 1-60 identities that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityIdsToDelete(Collection<String> identityIdsToDelete);

        /**
         * <p>
         * A list of 1-60 identities that you want to delete.
         * </p>
         * 
         * @param identityIdsToDelete
         *        A list of 1-60 identities that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityIdsToDelete(String... identityIdsToDelete);
    }

    static final class BuilderImpl implements Builder {
        private List<String> identityIdsToDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIdentitiesRequest model) {
            identityIdsToDelete(model.identityIdsToDelete);
        }

        public final Collection<String> getIdentityIdsToDelete() {
            return identityIdsToDelete;
        }

        @Override
        public final Builder identityIdsToDelete(Collection<String> identityIdsToDelete) {
            this.identityIdsToDelete = IdentityIdListCopier.copy(identityIdsToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityIdsToDelete(String... identityIdsToDelete) {
            identityIdsToDelete(Arrays.asList(identityIdsToDelete));
            return this;
        }

        public final void setIdentityIdsToDelete(Collection<String> identityIdsToDelete) {
            this.identityIdsToDelete = IdentityIdListCopier.copy(identityIdsToDelete);
        }

        @Override
        public DeleteIdentitiesRequest build() {
            return new DeleteIdentitiesRequest(this);
        }
    }
}
