/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returned in response to a successful <code>DeleteIdentities</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteIdentitiesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DeleteIdentitiesResponse.Builder, DeleteIdentitiesResponse> {
    private final List<UnprocessedIdentityId> unprocessedIdentityIds;

    private DeleteIdentitiesResponse(BuilderImpl builder) {
        this.unprocessedIdentityIds = builder.unprocessedIdentityIds;
    }

    /**
     * <p>
     * An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and IdentityId.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and IdentityId.
     */
    public List<UnprocessedIdentityId> unprocessedIdentityIds() {
        return unprocessedIdentityIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unprocessedIdentityIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIdentitiesResponse)) {
            return false;
        }
        DeleteIdentitiesResponse other = (DeleteIdentitiesResponse) obj;
        return Objects.equals(unprocessedIdentityIds(), other.unprocessedIdentityIds());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (unprocessedIdentityIds() != null) {
            sb.append("UnprocessedIdentityIds: ").append(unprocessedIdentityIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UnprocessedIdentityIds":
            return Optional.of(clazz.cast(unprocessedIdentityIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteIdentitiesResponse> {
        /**
         * <p>
         * An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and IdentityId.
         * </p>
         * 
         * @param unprocessedIdentityIds
         *        An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and IdentityId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedIdentityIds(Collection<UnprocessedIdentityId> unprocessedIdentityIds);

        /**
         * <p>
         * An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and IdentityId.
         * </p>
         * 
         * @param unprocessedIdentityIds
         *        An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and IdentityId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedIdentityIds(UnprocessedIdentityId... unprocessedIdentityIds);
    }

    static final class BuilderImpl implements Builder {
        private List<UnprocessedIdentityId> unprocessedIdentityIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIdentitiesResponse model) {
            unprocessedIdentityIds(model.unprocessedIdentityIds);
        }

        public final Collection<UnprocessedIdentityId.Builder> getUnprocessedIdentityIds() {
            return unprocessedIdentityIds != null ? unprocessedIdentityIds.stream().map(UnprocessedIdentityId::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedIdentityIds(Collection<UnprocessedIdentityId> unprocessedIdentityIds) {
            this.unprocessedIdentityIds = UnprocessedIdentityIdListCopier.copy(unprocessedIdentityIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedIdentityIds(UnprocessedIdentityId... unprocessedIdentityIds) {
            unprocessedIdentityIds(Arrays.asList(unprocessedIdentityIds));
            return this;
        }

        public final void setUnprocessedIdentityIds(Collection<UnprocessedIdentityId.BuilderImpl> unprocessedIdentityIds) {
            this.unprocessedIdentityIds = UnprocessedIdentityIdListCopier.copyFromBuilder(unprocessedIdentityIds);
        }

        @Override
        public DeleteIdentitiesResponse build() {
            return new DeleteIdentitiesResponse(this);
        }
    }
}
