/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response to a ListIdentities request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListIdentitiesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListIdentitiesResponse.Builder, ListIdentitiesResponse> {
    private final String identityPoolId;

    private final List<IdentityDescription> identities;

    private final String nextToken;

    private ListIdentitiesResponse(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.identities = builder.identities;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An identity pool ID in the format REGION:GUID.
     * </p>
     * 
     * @return An identity pool ID in the format REGION:GUID.
     */
    public String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * An object containing a set of identities and associated mappings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An object containing a set of identities and associated mappings.
     */
    public List<IdentityDescription> identities() {
        return identities;
    }

    /**
     * <p>
     * A pagination token.
     * </p>
     * 
     * @return A pagination token.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(identities());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentitiesResponse)) {
            return false;
        }
        ListIdentitiesResponse other = (ListIdentitiesResponse) obj;
        return Objects.equals(identityPoolId(), other.identityPoolId()) && Objects.equals(identities(), other.identities())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(identityPoolId()).append(",");
        }
        if (identities() != null) {
            sb.append("Identities: ").append(identities()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPoolId":
            return Optional.of(clazz.cast(identityPoolId()));
        case "Identities":
            return Optional.of(clazz.cast(identities()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListIdentitiesResponse> {
        /**
         * <p>
         * An identity pool ID in the format REGION:GUID.
         * </p>
         * 
         * @param identityPoolId
         *        An identity pool ID in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * An object containing a set of identities and associated mappings.
         * </p>
         * 
         * @param identities
         *        An object containing a set of identities and associated mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identities(Collection<IdentityDescription> identities);

        /**
         * <p>
         * An object containing a set of identities and associated mappings.
         * </p>
         * 
         * @param identities
         *        An object containing a set of identities and associated mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identities(IdentityDescription... identities);

        /**
         * <p>
         * A pagination token.
         * </p>
         * 
         * @param nextToken
         *        A pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private String identityPoolId;

        private List<IdentityDescription> identities;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentitiesResponse model) {
            identityPoolId(model.identityPoolId);
            identities(model.identities);
            nextToken(model.nextToken);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Collection<IdentityDescription.Builder> getIdentities() {
            return identities != null ? identities.stream().map(IdentityDescription::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder identities(Collection<IdentityDescription> identities) {
            this.identities = IdentitiesListCopier.copy(identities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identities(IdentityDescription... identities) {
            identities(Arrays.asList(identities));
            return this;
        }

        public final void setIdentities(Collection<IdentityDescription.BuilderImpl> identities) {
            this.identities = IdentitiesListCopier.copyFromBuilder(identities);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIdentitiesResponse build() {
            return new ListIdentitiesResponse(this);
        }
    }
}
