/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.transform.MappingRuleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rule that maps a claim name, a claim value, and a match type to a role ARN.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MappingRule implements StructuredPojo, ToCopyableBuilder<MappingRule.Builder, MappingRule> {
    private final String claim;

    private final String matchType;

    private final String value;

    private final String roleARN;

    private MappingRule(BuilderImpl builder) {
        this.claim = builder.claim;
        this.matchType = builder.matchType;
        this.value = builder.value;
        this.roleARN = builder.roleARN;
    }

    /**
     * <p>
     * The claim name that must be present in the token, for example, "isAdmin" or "paid".
     * </p>
     * 
     * @return The claim name that must be present in the token, for example, "isAdmin" or "paid".
     */
    public String claim() {
        return claim;
    }

    /**
     * <p>
     * The match condition that specifies how closely the claim value in the IdP token must match <code>Value</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchType} will
     * return {@link MappingRuleMatchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #matchTypeString}.
     * </p>
     * 
     * @return The match condition that specifies how closely the claim value in the IdP token must match
     *         <code>Value</code>.
     * @see MappingRuleMatchType
     */
    public MappingRuleMatchType matchType() {
        return MappingRuleMatchType.fromValue(matchType);
    }

    /**
     * <p>
     * The match condition that specifies how closely the claim value in the IdP token must match <code>Value</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchType} will
     * return {@link MappingRuleMatchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #matchTypeString}.
     * </p>
     * 
     * @return The match condition that specifies how closely the claim value in the IdP token must match
     *         <code>Value</code>.
     * @see MappingRuleMatchType
     */
    public String matchTypeString() {
        return matchType;
    }

    /**
     * <p>
     * A brief string that the claim must match, for example, "paid" or "yes".
     * </p>
     * 
     * @return A brief string that the claim must match, for example, "paid" or "yes".
     */
    public String value() {
        return value;
    }

    /**
     * <p>
     * The role ARN.
     * </p>
     * 
     * @return The role ARN.
     */
    public String roleARN() {
        return roleARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(claim());
        hashCode = 31 * hashCode + Objects.hashCode(matchTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MappingRule)) {
            return false;
        }
        MappingRule other = (MappingRule) obj;
        return Objects.equals(claim(), other.claim()) && Objects.equals(matchTypeString(), other.matchTypeString())
                && Objects.equals(value(), other.value()) && Objects.equals(roleARN(), other.roleARN());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (claim() != null) {
            sb.append("Claim: ").append(claim()).append(",");
        }
        if (matchTypeString() != null) {
            sb.append("MatchType: ").append(matchTypeString()).append(",");
        }
        if (value() != null) {
            sb.append("Value: ").append(value()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Claim":
            return Optional.of(clazz.cast(claim()));
        case "MatchType":
            return Optional.of(clazz.cast(matchTypeString()));
        case "Value":
            return Optional.of(clazz.cast(value()));
        case "RoleARN":
            return Optional.of(clazz.cast(roleARN()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MappingRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MappingRule> {
        /**
         * <p>
         * The claim name that must be present in the token, for example, "isAdmin" or "paid".
         * </p>
         * 
         * @param claim
         *        The claim name that must be present in the token, for example, "isAdmin" or "paid".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder claim(String claim);

        /**
         * <p>
         * The match condition that specifies how closely the claim value in the IdP token must match <code>Value</code>
         * .
         * </p>
         * 
         * @param matchType
         *        The match condition that specifies how closely the claim value in the IdP token must match
         *        <code>Value</code>.
         * @see MappingRuleMatchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MappingRuleMatchType
         */
        Builder matchType(String matchType);

        /**
         * <p>
         * The match condition that specifies how closely the claim value in the IdP token must match <code>Value</code>
         * .
         * </p>
         * 
         * @param matchType
         *        The match condition that specifies how closely the claim value in the IdP token must match
         *        <code>Value</code>.
         * @see MappingRuleMatchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MappingRuleMatchType
         */
        Builder matchType(MappingRuleMatchType matchType);

        /**
         * <p>
         * A brief string that the claim must match, for example, "paid" or "yes".
         * </p>
         * 
         * @param value
         *        A brief string that the claim must match, for example, "paid" or "yes".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The role ARN.
         * </p>
         * 
         * @param roleARN
         *        The role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);
    }

    static final class BuilderImpl implements Builder {
        private String claim;

        private String matchType;

        private String value;

        private String roleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(MappingRule model) {
            claim(model.claim);
            matchType(model.matchType);
            value(model.value);
            roleARN(model.roleARN);
        }

        public final String getClaim() {
            return claim;
        }

        @Override
        public final Builder claim(String claim) {
            this.claim = claim;
            return this;
        }

        public final void setClaim(String claim) {
            this.claim = claim;
        }

        public final String getMatchType() {
            return matchType;
        }

        @Override
        public final Builder matchType(String matchType) {
            this.matchType = matchType;
            return this;
        }

        @Override
        public final Builder matchType(MappingRuleMatchType matchType) {
            this.matchType(matchType.toString());
            return this;
        }

        public final void setMatchType(String matchType) {
            this.matchType = matchType;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public MappingRule build() {
            return new MappingRule(this);
        }
    }
}
