/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cognitoidentity.model.RoleMapping;
import software.amazon.awssdk.services.cognitoidentity.model.RoleMappingMapCopier;
import software.amazon.awssdk.services.cognitoidentity.model.RolesMapCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetIdentityPoolRolesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SetIdentityPoolRolesRequest> {
    private final String identityPoolId;
    private final Map<String, String> roles;
    private final Map<String, RoleMapping> roleMappings;

    private SetIdentityPoolRolesRequest(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.roles = builder.roles;
        this.roleMappings = builder.roleMappings;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public Map<String, String> roles() {
        return this.roles;
    }

    public Map<String, RoleMapping> roleMappings() {
        return this.roleMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roles());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleMappings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetIdentityPoolRolesRequest)) {
            return false;
        }
        SetIdentityPoolRolesRequest other = (SetIdentityPoolRolesRequest)((Object)obj);
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.roles(), other.roles()) && Objects.equals(this.roleMappings(), other.roleMappings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.identityPoolId()).append(",");
        }
        if (this.roles() != null) {
            sb.append("Roles: ").append(this.roles()).append(",");
        }
        if (this.roleMappings() != null) {
            sb.append("RoleMappings: ").append(this.roleMappings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.of(clazz.cast(this.identityPoolId()));
            }
            case "Roles": {
                return Optional.of(clazz.cast(this.roles()));
            }
            case "RoleMappings": {
                return Optional.of(clazz.cast(this.roleMappings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String identityPoolId;
        private Map<String, String> roles;
        private Map<String, RoleMapping> roleMappings;

        private BuilderImpl() {
        }

        private BuilderImpl(SetIdentityPoolRolesRequest model) {
            this.identityPoolId(model.identityPoolId);
            this.roles(model.roles);
            this.roleMappings(model.roleMappings);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Map<String, String> getRoles() {
            return this.roles;
        }

        @Override
        public final Builder roles(Map<String, String> roles) {
            this.roles = RolesMapCopier.copy(roles);
            return this;
        }

        public final void setRoles(Map<String, String> roles) {
            this.roles = RolesMapCopier.copy(roles);
        }

        public final Map<String, RoleMapping.Builder> getRoleMappings() {
            return this.roleMappings != null ? CollectionUtils.mapValues(this.roleMappings, RoleMapping::toBuilder) : null;
        }

        @Override
        public final Builder roleMappings(Map<String, RoleMapping> roleMappings) {
            this.roleMappings = RoleMappingMapCopier.copy(roleMappings);
            return this;
        }

        public final void setRoleMappings(Map<String, RoleMapping.BuilderImpl> roleMappings) {
            this.roleMappings = RoleMappingMapCopier.copyFromBuilder(roleMappings);
        }

        public SetIdentityPoolRolesRequest build() {
            return new SetIdentityPoolRolesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetIdentityPoolRolesRequest> {
        public Builder identityPoolId(String var1);

        public Builder roles(Map<String, String> var1);

        public Builder roleMappings(Map<String, RoleMapping> var1);
    }
}

