/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to the <code>GetCredentialsForIdentity</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetCredentialsForIdentityRequest extends CognitoIdentityRequest implements
        ToCopyableBuilder<GetCredentialsForIdentityRequest.Builder, GetCredentialsForIdentityRequest> {
    private final String identityId;

    private final Map<String, String> logins;

    private final String customRoleArn;

    private GetCredentialsForIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.identityId = builder.identityId;
        this.logins = builder.logins;
        this.customRoleArn = builder.customRoleArn;
    }

    /**
     * <p>
     * A unique identifier in the format REGION:GUID.
     * </p>
     * 
     * @return A unique identifier in the format REGION:GUID.
     */
    public String identityId() {
        return identityId;
    }

    /**
     * <p>
     * A set of optional name-value pairs that map provider names to provider tokens.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A set of optional name-value pairs that map provider names to provider tokens.
     */
    public Map<String, String> logins() {
        return logins;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were received in the token from the
     * identity provider. For example, a SAML-based identity provider. This parameter is optional for identity providers
     * that do not support role customization.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were received in the token
     *         from the identity provider. For example, a SAML-based identity provider. This parameter is optional for
     *         identity providers that do not support role customization.
     */
    public String customRoleArn() {
        return customRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityId());
        hashCode = 31 * hashCode + Objects.hashCode(logins());
        hashCode = 31 * hashCode + Objects.hashCode(customRoleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCredentialsForIdentityRequest)) {
            return false;
        }
        GetCredentialsForIdentityRequest other = (GetCredentialsForIdentityRequest) obj;
        return Objects.equals(identityId(), other.identityId()) && Objects.equals(logins(), other.logins())
                && Objects.equals(customRoleArn(), other.customRoleArn());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (identityId() != null) {
            sb.append("IdentityId: ").append(identityId()).append(",");
        }
        if (logins() != null) {
            sb.append("Logins: ").append(logins()).append(",");
        }
        if (customRoleArn() != null) {
            sb.append("CustomRoleArn: ").append(customRoleArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityId":
            return Optional.of(clazz.cast(identityId()));
        case "Logins":
            return Optional.of(clazz.cast(logins()));
        case "CustomRoleArn":
            return Optional.of(clazz.cast(customRoleArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityRequest.Builder, CopyableBuilder<Builder, GetCredentialsForIdentityRequest> {
        /**
         * <p>
         * A unique identifier in the format REGION:GUID.
         * </p>
         * 
         * @param identityId
         *        A unique identifier in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * A set of optional name-value pairs that map provider names to provider tokens.
         * </p>
         * 
         * @param logins
         *        A set of optional name-value pairs that map provider names to provider tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logins(Map<String, String> logins);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were received in the token from
         * the identity provider. For example, a SAML-based identity provider. This parameter is optional for identity
         * providers that do not support role customization.
         * </p>
         * 
         * @param customRoleArn
         *        The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were received in the
         *        token from the identity provider. For example, a SAML-based identity provider. This parameter is
         *        optional for identity providers that do not support role customization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRoleArn(String customRoleArn);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends CognitoIdentityRequest.BuilderImpl implements Builder {
        private String identityId;

        private Map<String, String> logins;

        private String customRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCredentialsForIdentityRequest model) {
            identityId(model.identityId);
            logins(model.logins);
            customRoleArn(model.customRoleArn);
        }

        public final String getIdentityId() {
            return identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final Map<String, String> getLogins() {
            return logins;
        }

        @Override
        public final Builder logins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
            return this;
        }

        public final void setLogins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
        }

        public final String getCustomRoleArn() {
            return customRoleArn;
        }

        @Override
        public final Builder customRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
            return this;
        }

        public final void setCustomRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetCredentialsForIdentityRequest build() {
            return new GetCredentialsForIdentityRequest(this);
        }
    }
}
