/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returned in response to a successful <code>GetCredentialsForIdentity</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetCredentialsForIdentityResponse extends CognitoIdentityResponse implements
        ToCopyableBuilder<GetCredentialsForIdentityResponse.Builder, GetCredentialsForIdentityResponse> {
    private final String identityId;

    private final Credentials credentials;

    private GetCredentialsForIdentityResponse(BuilderImpl builder) {
        super(builder);
        this.identityId = builder.identityId;
        this.credentials = builder.credentials;
    }

    /**
     * <p>
     * A unique identifier in the format REGION:GUID.
     * </p>
     * 
     * @return A unique identifier in the format REGION:GUID.
     */
    public String identityId() {
        return identityId;
    }

    /**
     * <p>
     * Credentials for the provided identity ID.
     * </p>
     * 
     * @return Credentials for the provided identity ID.
     */
    public Credentials credentials() {
        return credentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityId());
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCredentialsForIdentityResponse)) {
            return false;
        }
        GetCredentialsForIdentityResponse other = (GetCredentialsForIdentityResponse) obj;
        return Objects.equals(identityId(), other.identityId()) && Objects.equals(credentials(), other.credentials());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (identityId() != null) {
            sb.append("IdentityId: ").append(identityId()).append(",");
        }
        if (credentials() != null) {
            sb.append("Credentials: ").append(credentials()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityId":
            return Optional.of(clazz.cast(identityId()));
        case "Credentials":
            return Optional.of(clazz.cast(credentials()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityResponse.Builder, CopyableBuilder<Builder, GetCredentialsForIdentityResponse> {
        /**
         * <p>
         * A unique identifier in the format REGION:GUID.
         * </p>
         * 
         * @param identityId
         *        A unique identifier in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * Credentials for the provided identity ID.
         * </p>
         * 
         * @param credentials
         *        Credentials for the provided identity ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(Credentials credentials);

        /**
         * <p>
         * Credentials for the provided identity ID.
         * </p>
         * This is a convenience that creates an instance of the {@link Credentials.Builder} avoiding the need to create
         * one manually via {@link Credentials#builder()}.
         *
         * When the {@link Consumer} completes, {@link Credentials.Builder#build()} is called immediately and its result
         * is passed to {@link #credentials(Credentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link Credentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(Credentials)
         */
        default Builder credentials(Consumer<Credentials.Builder> credentials) {
            return credentials(Credentials.builder().apply(credentials).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityResponse.BuilderImpl implements Builder {
        private String identityId;

        private Credentials credentials;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCredentialsForIdentityResponse model) {
            identityId(model.identityId);
            credentials(model.credentials);
        }

        public final String getIdentityId() {
            return identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final Credentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public GetCredentialsForIdentityResponse build() {
            return new GetCredentialsForIdentityResponse(this);
        }
    }
}
