/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to the GetId action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetIdRequest extends CognitoIdentityRequest implements ToCopyableBuilder<GetIdRequest.Builder, GetIdRequest> {
    private final String accountId;

    private final String identityPoolId;

    private final Map<String, String> logins;

    private GetIdRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.identityPoolId = builder.identityPoolId;
        this.logins = builder.logins;
    }

    /**
     * <p>
     * A standard AWS account ID (9+ digits).
     * </p>
     * 
     * @return A standard AWS account ID (9+ digits).
     */
    public String accountId() {
        return accountId;
    }

    /**
     * <p>
     * An identity pool ID in the format REGION:GUID.
     * </p>
     * 
     * @return An identity pool ID in the format REGION:GUID.
     */
    public String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * A set of optional name-value pairs that map provider names to provider tokens. The available provider names for
     * <code>Logins</code> are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Facebook: <code>graph.facebook.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito Identity Provider: <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Google: <code>accounts.google.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon: <code>www.amazon.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Twitter: <code>api.twitter.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Digits: <code>www.digits.com</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A set of optional name-value pairs that map provider names to provider tokens. The available provider
     *         names for <code>Logins</code> are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Facebook: <code>graph.facebook.com</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Cognito Identity Provider: <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Google: <code>accounts.google.com</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon: <code>www.amazon.com</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Twitter: <code>api.twitter.com</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Digits: <code>www.digits.com</code>
     *         </p>
     *         </li>
     */
    public Map<String, String> logins() {
        return logins;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(logins());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdRequest)) {
            return false;
        }
        GetIdRequest other = (GetIdRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(identityPoolId(), other.identityPoolId())
                && Objects.equals(logins(), other.logins());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (accountId() != null) {
            sb.append("AccountId: ").append(accountId()).append(",");
        }
        if (identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(identityPoolId()).append(",");
        }
        if (logins() != null) {
            sb.append("Logins: ").append(logins()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.of(clazz.cast(accountId()));
        case "IdentityPoolId":
            return Optional.of(clazz.cast(identityPoolId()));
        case "Logins":
            return Optional.of(clazz.cast(logins()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityRequest.Builder, CopyableBuilder<Builder, GetIdRequest> {
        /**
         * <p>
         * A standard AWS account ID (9+ digits).
         * </p>
         * 
         * @param accountId
         *        A standard AWS account ID (9+ digits).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * An identity pool ID in the format REGION:GUID.
         * </p>
         * 
         * @param identityPoolId
         *        An identity pool ID in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * A set of optional name-value pairs that map provider names to provider tokens. The available provider names
         * for <code>Logins</code> are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Facebook: <code>graph.facebook.com</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Cognito Identity Provider: <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Google: <code>accounts.google.com</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon: <code>www.amazon.com</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Twitter: <code>api.twitter.com</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Digits: <code>www.digits.com</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param logins
         *        A set of optional name-value pairs that map provider names to provider tokens. The available provider
         *        names for <code>Logins</code> are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Facebook: <code>graph.facebook.com</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Cognito Identity Provider: <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Google: <code>accounts.google.com</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon: <code>www.amazon.com</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Twitter: <code>api.twitter.com</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Digits: <code>www.digits.com</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logins(Map<String, String> logins);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends CognitoIdentityRequest.BuilderImpl implements Builder {
        private String accountId;

        private String identityPoolId;

        private Map<String, String> logins;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdRequest model) {
            accountId(model.accountId);
            identityPoolId(model.identityPoolId);
            logins(model.logins);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Map<String, String> getLogins() {
            return logins;
        }

        @Override
        public final Builder logins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
            return this;
        }

        public final void setLogins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetIdRequest build() {
            return new GetIdRequest(this);
        }
    }
}
