/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.transform.IdentityDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A description of the identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class IdentityDescription implements StructuredPojo, ToCopyableBuilder<IdentityDescription.Builder, IdentityDescription> {
    private final String identityId;

    private final List<String> logins;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private IdentityDescription(BuilderImpl builder) {
        this.identityId = builder.identityId;
        this.logins = builder.logins;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * A unique identifier in the format REGION:GUID.
     * </p>
     * 
     * @return A unique identifier in the format REGION:GUID.
     */
    public String identityId() {
        return identityId;
    }

    /**
     * <p>
     * A set of optional name-value pairs that map provider names to provider tokens.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A set of optional name-value pairs that map provider names to provider tokens.
     */
    public List<String> logins() {
        return logins;
    }

    /**
     * <p>
     * Date on which the identity was created.
     * </p>
     * 
     * @return Date on which the identity was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * Date on which the identity was last modified.
     * </p>
     * 
     * @return Date on which the identity was last modified.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityId());
        hashCode = 31 * hashCode + Objects.hashCode(logins());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityDescription)) {
            return false;
        }
        IdentityDescription other = (IdentityDescription) obj;
        return Objects.equals(identityId(), other.identityId()) && Objects.equals(logins(), other.logins())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (identityId() != null) {
            sb.append("IdentityId: ").append(identityId()).append(",");
        }
        if (logins() != null) {
            sb.append("Logins: ").append(logins()).append(",");
        }
        if (creationDate() != null) {
            sb.append("CreationDate: ").append(creationDate()).append(",");
        }
        if (lastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(lastModifiedDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityId":
            return Optional.of(clazz.cast(identityId()));
        case "Logins":
            return Optional.of(clazz.cast(logins()));
        case "CreationDate":
            return Optional.of(clazz.cast(creationDate()));
        case "LastModifiedDate":
            return Optional.of(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IdentityDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, IdentityDescription> {
        /**
         * <p>
         * A unique identifier in the format REGION:GUID.
         * </p>
         * 
         * @param identityId
         *        A unique identifier in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * A set of optional name-value pairs that map provider names to provider tokens.
         * </p>
         * 
         * @param logins
         *        A set of optional name-value pairs that map provider names to provider tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logins(Collection<String> logins);

        /**
         * <p>
         * A set of optional name-value pairs that map provider names to provider tokens.
         * </p>
         * 
         * @param logins
         *        A set of optional name-value pairs that map provider names to provider tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logins(String... logins);

        /**
         * <p>
         * Date on which the identity was created.
         * </p>
         * 
         * @param creationDate
         *        Date on which the identity was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * Date on which the identity was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        Date on which the identity was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);
    }

    static final class BuilderImpl implements Builder {
        private String identityId;

        private List<String> logins;

        private Instant creationDate;

        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityDescription model) {
            identityId(model.identityId);
            logins(model.logins);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final String getIdentityId() {
            return identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final Collection<String> getLogins() {
            return logins;
        }

        @Override
        public final Builder logins(Collection<String> logins) {
            this.logins = LoginsListCopier.copy(logins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logins(String... logins) {
            logins(Arrays.asList(logins));
            return this;
        }

        public final void setLogins(Collection<String> logins) {
            this.logins = LoginsListCopier.copy(logins);
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public IdentityDescription build() {
            return new IdentityDescription(this);
        }
    }
}
