/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing an Amazon Cognito identity pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateIdentityPoolResponse extends CognitoIdentityResponse implements
        ToCopyableBuilder<UpdateIdentityPoolResponse.Builder, UpdateIdentityPoolResponse> {
    private final String identityPoolId;

    private final String identityPoolName;

    private final Boolean allowUnauthenticatedIdentities;

    private final Map<String, String> supportedLoginProviders;

    private final String developerProviderName;

    private final List<String> openIdConnectProviderARNs;

    private final List<CognitoIdentityProvider> cognitoIdentityProviders;

    private final List<String> samlProviderARNs;

    private UpdateIdentityPoolResponse(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identityPoolName = builder.identityPoolName;
        this.allowUnauthenticatedIdentities = builder.allowUnauthenticatedIdentities;
        this.supportedLoginProviders = builder.supportedLoginProviders;
        this.developerProviderName = builder.developerProviderName;
        this.openIdConnectProviderARNs = builder.openIdConnectProviderARNs;
        this.cognitoIdentityProviders = builder.cognitoIdentityProviders;
        this.samlProviderARNs = builder.samlProviderARNs;
    }

    /**
     * <p>
     * An identity pool ID in the format REGION:GUID.
     * </p>
     * 
     * @return An identity pool ID in the format REGION:GUID.
     */
    public String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * A string that you provide.
     * </p>
     * 
     * @return A string that you provide.
     */
    public String identityPoolName() {
        return identityPoolName;
    }

    /**
     * <p>
     * TRUE if the identity pool supports unauthenticated logins.
     * </p>
     * 
     * @return TRUE if the identity pool supports unauthenticated logins.
     */
    public Boolean allowUnauthenticatedIdentities() {
        return allowUnauthenticatedIdentities;
    }

    /**
     * <p>
     * Optional key:value pairs mapping provider names to provider app IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Optional key:value pairs mapping provider names to provider app IDs.
     */
    public Map<String, String> supportedLoginProviders() {
        return supportedLoginProviders;
    }

    /**
     * <p>
     * The "domain" by which Cognito will refer to your users.
     * </p>
     * 
     * @return The "domain" by which Cognito will refer to your users.
     */
    public String developerProviderName() {
        return developerProviderName;
    }

    /**
     * <p>
     * A list of OpendID Connect provider ARNs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of OpendID Connect provider ARNs.
     */
    public List<String> openIdConnectProviderARNs() {
        return openIdConnectProviderARNs;
    }

    /**
     * <p>
     * A list representing an Amazon Cognito Identity User Pool and its client ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list representing an Amazon Cognito Identity User Pool and its client ID.
     */
    public List<CognitoIdentityProvider> cognitoIdentityProviders() {
        return cognitoIdentityProviders;
    }

    /**
     * <p>
     * An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.
     */
    public List<String> samlProviderARNs() {
        return samlProviderARNs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolName());
        hashCode = 31 * hashCode + Objects.hashCode(allowUnauthenticatedIdentities());
        hashCode = 31 * hashCode + Objects.hashCode(supportedLoginProviders());
        hashCode = 31 * hashCode + Objects.hashCode(developerProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(openIdConnectProviderARNs());
        hashCode = 31 * hashCode + Objects.hashCode(cognitoIdentityProviders());
        hashCode = 31 * hashCode + Objects.hashCode(samlProviderARNs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIdentityPoolResponse)) {
            return false;
        }
        UpdateIdentityPoolResponse other = (UpdateIdentityPoolResponse) obj;
        return Objects.equals(identityPoolId(), other.identityPoolId())
                && Objects.equals(identityPoolName(), other.identityPoolName())
                && Objects.equals(allowUnauthenticatedIdentities(), other.allowUnauthenticatedIdentities())
                && Objects.equals(supportedLoginProviders(), other.supportedLoginProviders())
                && Objects.equals(developerProviderName(), other.developerProviderName())
                && Objects.equals(openIdConnectProviderARNs(), other.openIdConnectProviderARNs())
                && Objects.equals(cognitoIdentityProviders(), other.cognitoIdentityProviders())
                && Objects.equals(samlProviderARNs(), other.samlProviderARNs());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(identityPoolId()).append(",");
        }
        if (identityPoolName() != null) {
            sb.append("IdentityPoolName: ").append(identityPoolName()).append(",");
        }
        if (allowUnauthenticatedIdentities() != null) {
            sb.append("AllowUnauthenticatedIdentities: ").append(allowUnauthenticatedIdentities()).append(",");
        }
        if (supportedLoginProviders() != null) {
            sb.append("SupportedLoginProviders: ").append(supportedLoginProviders()).append(",");
        }
        if (developerProviderName() != null) {
            sb.append("DeveloperProviderName: ").append(developerProviderName()).append(",");
        }
        if (openIdConnectProviderARNs() != null) {
            sb.append("OpenIdConnectProviderARNs: ").append(openIdConnectProviderARNs()).append(",");
        }
        if (cognitoIdentityProviders() != null) {
            sb.append("CognitoIdentityProviders: ").append(cognitoIdentityProviders()).append(",");
        }
        if (samlProviderARNs() != null) {
            sb.append("SamlProviderARNs: ").append(samlProviderARNs()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPoolId":
            return Optional.of(clazz.cast(identityPoolId()));
        case "IdentityPoolName":
            return Optional.of(clazz.cast(identityPoolName()));
        case "AllowUnauthenticatedIdentities":
            return Optional.of(clazz.cast(allowUnauthenticatedIdentities()));
        case "SupportedLoginProviders":
            return Optional.of(clazz.cast(supportedLoginProviders()));
        case "DeveloperProviderName":
            return Optional.of(clazz.cast(developerProviderName()));
        case "OpenIdConnectProviderARNs":
            return Optional.of(clazz.cast(openIdConnectProviderARNs()));
        case "CognitoIdentityProviders":
            return Optional.of(clazz.cast(cognitoIdentityProviders()));
        case "SamlProviderARNs":
            return Optional.of(clazz.cast(samlProviderARNs()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityResponse.Builder, CopyableBuilder<Builder, UpdateIdentityPoolResponse> {
        /**
         * <p>
         * An identity pool ID in the format REGION:GUID.
         * </p>
         * 
         * @param identityPoolId
         *        An identity pool ID in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * A string that you provide.
         * </p>
         * 
         * @param identityPoolName
         *        A string that you provide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolName(String identityPoolName);

        /**
         * <p>
         * TRUE if the identity pool supports unauthenticated logins.
         * </p>
         * 
         * @param allowUnauthenticatedIdentities
         *        TRUE if the identity pool supports unauthenticated logins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities);

        /**
         * <p>
         * Optional key:value pairs mapping provider names to provider app IDs.
         * </p>
         * 
         * @param supportedLoginProviders
         *        Optional key:value pairs mapping provider names to provider app IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedLoginProviders(Map<String, String> supportedLoginProviders);

        /**
         * <p>
         * The "domain" by which Cognito will refer to your users.
         * </p>
         * 
         * @param developerProviderName
         *        The "domain" by which Cognito will refer to your users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder developerProviderName(String developerProviderName);

        /**
         * <p>
         * A list of OpendID Connect provider ARNs.
         * </p>
         * 
         * @param openIdConnectProviderARNs
         *        A list of OpendID Connect provider ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIdConnectProviderARNs(Collection<String> openIdConnectProviderARNs);

        /**
         * <p>
         * A list of OpendID Connect provider ARNs.
         * </p>
         * 
         * @param openIdConnectProviderARNs
         *        A list of OpendID Connect provider ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIdConnectProviderARNs(String... openIdConnectProviderARNs);

        /**
         * <p>
         * A list representing an Amazon Cognito Identity User Pool and its client ID.
         * </p>
         * 
         * @param cognitoIdentityProviders
         *        A list representing an Amazon Cognito Identity User Pool and its client ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoIdentityProviders(Collection<CognitoIdentityProvider> cognitoIdentityProviders);

        /**
         * <p>
         * A list representing an Amazon Cognito Identity User Pool and its client ID.
         * </p>
         * 
         * @param cognitoIdentityProviders
         *        A list representing an Amazon Cognito Identity User Pool and its client ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoIdentityProviders(CognitoIdentityProvider... cognitoIdentityProviders);

        /**
         * <p>
         * An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.
         * </p>
         * 
         * @param samlProviderARNs
         *        An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlProviderARNs(Collection<String> samlProviderARNs);

        /**
         * <p>
         * An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.
         * </p>
         * 
         * @param samlProviderARNs
         *        An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlProviderARNs(String... samlProviderARNs);
    }

    static final class BuilderImpl extends CognitoIdentityResponse.BuilderImpl implements Builder {
        private String identityPoolId;

        private String identityPoolName;

        private Boolean allowUnauthenticatedIdentities;

        private Map<String, String> supportedLoginProviders;

        private String developerProviderName;

        private List<String> openIdConnectProviderARNs;

        private List<CognitoIdentityProvider> cognitoIdentityProviders;

        private List<String> samlProviderARNs;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIdentityPoolResponse model) {
            identityPoolId(model.identityPoolId);
            identityPoolName(model.identityPoolName);
            allowUnauthenticatedIdentities(model.allowUnauthenticatedIdentities);
            supportedLoginProviders(model.supportedLoginProviders);
            developerProviderName(model.developerProviderName);
            openIdConnectProviderARNs(model.openIdConnectProviderARNs);
            cognitoIdentityProviders(model.cognitoIdentityProviders);
            samlProviderARNs(model.samlProviderARNs);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getIdentityPoolName() {
            return identityPoolName;
        }

        @Override
        public final Builder identityPoolName(String identityPoolName) {
            this.identityPoolName = identityPoolName;
            return this;
        }

        public final void setIdentityPoolName(String identityPoolName) {
            this.identityPoolName = identityPoolName;
        }

        public final Boolean getAllowUnauthenticatedIdentities() {
            return allowUnauthenticatedIdentities;
        }

        @Override
        public final Builder allowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
            this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities;
            return this;
        }

        public final void setAllowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
            this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities;
        }

        public final Map<String, String> getSupportedLoginProviders() {
            return supportedLoginProviders;
        }

        @Override
        public final Builder supportedLoginProviders(Map<String, String> supportedLoginProviders) {
            this.supportedLoginProviders = IdentityProvidersCopier.copy(supportedLoginProviders);
            return this;
        }

        public final void setSupportedLoginProviders(Map<String, String> supportedLoginProviders) {
            this.supportedLoginProviders = IdentityProvidersCopier.copy(supportedLoginProviders);
        }

        public final String getDeveloperProviderName() {
            return developerProviderName;
        }

        @Override
        public final Builder developerProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
            return this;
        }

        public final void setDeveloperProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
        }

        public final Collection<String> getOpenIdConnectProviderARNs() {
            return openIdConnectProviderARNs;
        }

        @Override
        public final Builder openIdConnectProviderARNs(Collection<String> openIdConnectProviderARNs) {
            this.openIdConnectProviderARNs = OIDCProviderListCopier.copy(openIdConnectProviderARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder openIdConnectProviderARNs(String... openIdConnectProviderARNs) {
            openIdConnectProviderARNs(Arrays.asList(openIdConnectProviderARNs));
            return this;
        }

        public final void setOpenIdConnectProviderARNs(Collection<String> openIdConnectProviderARNs) {
            this.openIdConnectProviderARNs = OIDCProviderListCopier.copy(openIdConnectProviderARNs);
        }

        public final Collection<CognitoIdentityProvider.Builder> getCognitoIdentityProviders() {
            return cognitoIdentityProviders != null ? cognitoIdentityProviders.stream().map(CognitoIdentityProvider::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cognitoIdentityProviders(Collection<CognitoIdentityProvider> cognitoIdentityProviders) {
            this.cognitoIdentityProviders = CognitoIdentityProviderListCopier.copy(cognitoIdentityProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cognitoIdentityProviders(CognitoIdentityProvider... cognitoIdentityProviders) {
            cognitoIdentityProviders(Arrays.asList(cognitoIdentityProviders));
            return this;
        }

        public final void setCognitoIdentityProviders(Collection<CognitoIdentityProvider.BuilderImpl> cognitoIdentityProviders) {
            this.cognitoIdentityProviders = CognitoIdentityProviderListCopier.copyFromBuilder(cognitoIdentityProviders);
        }

        public final Collection<String> getSamlProviderARNs() {
            return samlProviderARNs;
        }

        @Override
        public final Builder samlProviderARNs(Collection<String> samlProviderARNs) {
            this.samlProviderARNs = SAMLProviderListCopier.copy(samlProviderARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samlProviderARNs(String... samlProviderARNs) {
            samlProviderARNs(Arrays.asList(samlProviderARNs));
            return this;
        }

        public final void setSamlProviderARNs(Collection<String> samlProviderARNs) {
            this.samlProviderARNs = SAMLProviderListCopier.copy(samlProviderARNs);
        }

        @Override
        public UpdateIdentityPoolResponse build() {
            return new UpdateIdentityPoolResponse(this);
        }
    }
}
