/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.transform;

import java.util.List;
import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.cognitoidentity.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * IdentityDescriptionMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class IdentityDescriptionMarshaller {

    private static final MarshallingInfo<String> IDENTITYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityId").build();
    private static final MarshallingInfo<List> LOGINS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Logins").build();
    private static final MarshallingInfo<java.time.Instant> CREATIONDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate")
            .build();
    private static final MarshallingInfo<java.time.Instant> LASTMODIFIEDDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedDate")
            .build();

    private static final IdentityDescriptionMarshaller INSTANCE = new IdentityDescriptionMarshaller();

    public static IdentityDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(IdentityDescription identityDescription, ProtocolMarshaller protocolMarshaller) {

        if (identityDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(identityDescription.identityId(), IDENTITYID_BINDING);

            protocolMarshaller.marshall(identityDescription.logins(), LOGINS_BINDING);

            protocolMarshaller.marshall(identityDescription.creationDate(), CREATIONDATE_BINDING);

            protocolMarshaller.marshall(identityDescription.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
