/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.IdentityIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteIdentitiesRequest
extends CognitoIdentityRequest
implements ToCopyableBuilder<Builder, DeleteIdentitiesRequest> {
    private final List<String> identityIdsToDelete;

    private DeleteIdentitiesRequest(BuilderImpl builder) {
        super(builder);
        this.identityIdsToDelete = builder.identityIdsToDelete;
    }

    public List<String> identityIdsToDelete() {
        return this.identityIdsToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityIdsToDelete());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIdentitiesRequest)) {
            return false;
        }
        DeleteIdentitiesRequest other = (DeleteIdentitiesRequest)((Object)obj);
        return Objects.equals(this.identityIdsToDelete(), other.identityIdsToDelete());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identityIdsToDelete() != null) {
            sb.append("IdentityIdsToDelete: ").append(this.identityIdsToDelete()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityIdsToDelete": {
                return Optional.of(clazz.cast(this.identityIdsToDelete()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityRequest.BuilderImpl
    implements Builder {
        private List<String> identityIdsToDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIdentitiesRequest model) {
            this.identityIdsToDelete(model.identityIdsToDelete);
        }

        public final Collection<String> getIdentityIdsToDelete() {
            return this.identityIdsToDelete;
        }

        @Override
        public final Builder identityIdsToDelete(Collection<String> identityIdsToDelete) {
            this.identityIdsToDelete = IdentityIdListCopier.copy(identityIdsToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityIdsToDelete(String ... identityIdsToDelete) {
            this.identityIdsToDelete(Arrays.asList(identityIdsToDelete));
            return this;
        }

        public final void setIdentityIdsToDelete(Collection<String> identityIdsToDelete) {
            this.identityIdsToDelete = IdentityIdListCopier.copy(identityIdsToDelete);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteIdentitiesRequest build() {
            return new DeleteIdentitiesRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityRequest.Builder,
    CopyableBuilder<Builder, DeleteIdentitiesRequest> {
        public Builder identityIdsToDelete(Collection<String> var1);

        public Builder identityIdsToDelete(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

