/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.LoginsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeIdentityResponse
extends CognitoIdentityResponse
implements ToCopyableBuilder<Builder, DescribeIdentityResponse> {
    private final String identityId;
    private final List<String> logins;
    private final Instant creationDate;
    private final Instant lastModifiedDate;

    private DescribeIdentityResponse(BuilderImpl builder) {
        super(builder);
        this.identityId = builder.identityId;
        this.logins = builder.logins;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public String identityId() {
        return this.identityId;
    }

    public List<String> logins() {
        return this.logins;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.logins());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdentityResponse)) {
            return false;
        }
        DescribeIdentityResponse other = (DescribeIdentityResponse)((Object)obj);
        return Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.logins(), other.logins()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identityId() != null) {
            sb.append("IdentityId: ").append(this.identityId()).append(",");
        }
        if (this.logins() != null) {
            sb.append("Logins: ").append(this.logins()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.lastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.lastModifiedDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityId": {
                return Optional.of(clazz.cast(this.identityId()));
            }
            case "Logins": {
                return Optional.of(clazz.cast(this.logins()));
            }
            case "CreationDate": {
                return Optional.of(clazz.cast(this.creationDate()));
            }
            case "LastModifiedDate": {
                return Optional.of(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityResponse.BuilderImpl
    implements Builder {
        private String identityId;
        private List<String> logins;
        private Instant creationDate;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdentityResponse model) {
            this.identityId(model.identityId);
            this.logins(model.logins);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final Collection<String> getLogins() {
            return this.logins;
        }

        @Override
        public final Builder logins(Collection<String> logins) {
            this.logins = LoginsListCopier.copy(logins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logins(String ... logins) {
            this.logins(Arrays.asList(logins));
            return this;
        }

        public final void setLogins(Collection<String> logins) {
            this.logins = LoginsListCopier.copy(logins);
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public DescribeIdentityResponse build() {
            return new DescribeIdentityResponse(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityResponse.Builder,
    CopyableBuilder<Builder, DescribeIdentityResponse> {
        public Builder identityId(String var1);

        public Builder logins(Collection<String> var1);

        public Builder logins(String ... var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);
    }
}

