/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.LoginsMapCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetOpenIdTokenForDeveloperIdentityRequest
extends CognitoIdentityRequest
implements ToCopyableBuilder<Builder, GetOpenIdTokenForDeveloperIdentityRequest> {
    private final String identityPoolId;
    private final String identityId;
    private final Map<String, String> logins;
    private final Long tokenDuration;

    private GetOpenIdTokenForDeveloperIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identityId = builder.identityId;
        this.logins = builder.logins;
        this.tokenDuration = builder.tokenDuration;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public String identityId() {
        return this.identityId;
    }

    public Map<String, String> logins() {
        return this.logins;
    }

    public Long tokenDuration() {
        return this.tokenDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.logins());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenDuration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpenIdTokenForDeveloperIdentityRequest)) {
            return false;
        }
        GetOpenIdTokenForDeveloperIdentityRequest other = (GetOpenIdTokenForDeveloperIdentityRequest)((Object)obj);
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.logins(), other.logins()) && Objects.equals(this.tokenDuration(), other.tokenDuration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.identityPoolId()).append(",");
        }
        if (this.identityId() != null) {
            sb.append("IdentityId: ").append(this.identityId()).append(",");
        }
        if (this.logins() != null) {
            sb.append("Logins: ").append(this.logins()).append(",");
        }
        if (this.tokenDuration() != null) {
            sb.append("TokenDuration: ").append(this.tokenDuration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.of(clazz.cast(this.identityPoolId()));
            }
            case "IdentityId": {
                return Optional.of(clazz.cast(this.identityId()));
            }
            case "Logins": {
                return Optional.of(clazz.cast(this.logins()));
            }
            case "TokenDuration": {
                return Optional.of(clazz.cast(this.tokenDuration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityRequest.BuilderImpl
    implements Builder {
        private String identityPoolId;
        private String identityId;
        private Map<String, String> logins;
        private Long tokenDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpenIdTokenForDeveloperIdentityRequest model) {
            this.identityPoolId(model.identityPoolId);
            this.identityId(model.identityId);
            this.logins(model.logins);
            this.tokenDuration(model.tokenDuration);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final Map<String, String> getLogins() {
            return this.logins;
        }

        @Override
        public final Builder logins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
            return this;
        }

        public final void setLogins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
        }

        public final Long getTokenDuration() {
            return this.tokenDuration;
        }

        @Override
        public final Builder tokenDuration(Long tokenDuration) {
            this.tokenDuration = tokenDuration;
            return this;
        }

        public final void setTokenDuration(Long tokenDuration) {
            this.tokenDuration = tokenDuration;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetOpenIdTokenForDeveloperIdentityRequest build() {
            return new GetOpenIdTokenForDeveloperIdentityRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityRequest.Builder,
    CopyableBuilder<Builder, GetOpenIdTokenForDeveloperIdentityRequest> {
        public Builder identityPoolId(String var1);

        public Builder identityId(String var1);

        public Builder logins(Map<String, String> var1);

        public Builder tokenDuration(Long var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

