/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.LoginsMapCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetOpenIdTokenRequest
extends CognitoIdentityRequest
implements ToCopyableBuilder<Builder, GetOpenIdTokenRequest> {
    private final String identityId;
    private final Map<String, String> logins;

    private GetOpenIdTokenRequest(BuilderImpl builder) {
        super(builder);
        this.identityId = builder.identityId;
        this.logins = builder.logins;
    }

    public String identityId() {
        return this.identityId;
    }

    public Map<String, String> logins() {
        return this.logins;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.logins());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpenIdTokenRequest)) {
            return false;
        }
        GetOpenIdTokenRequest other = (GetOpenIdTokenRequest)((Object)obj);
        return Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.logins(), other.logins());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identityId() != null) {
            sb.append("IdentityId: ").append(this.identityId()).append(",");
        }
        if (this.logins() != null) {
            sb.append("Logins: ").append(this.logins()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityId": {
                return Optional.of(clazz.cast(this.identityId()));
            }
            case "Logins": {
                return Optional.of(clazz.cast(this.logins()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityRequest.BuilderImpl
    implements Builder {
        private String identityId;
        private Map<String, String> logins;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpenIdTokenRequest model) {
            this.identityId(model.identityId);
            this.logins(model.logins);
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final Map<String, String> getLogins() {
            return this.logins;
        }

        @Override
        public final Builder logins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
            return this;
        }

        public final void setLogins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetOpenIdTokenRequest build() {
            return new GetOpenIdTokenRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityRequest.Builder,
    CopyableBuilder<Builder, GetOpenIdTokenRequest> {
        public Builder identityId(String var1);

        public Builder logins(Map<String, String> var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

