/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returned in response to a successful <code>GetIdentityPoolRoles</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetIdentityPoolRolesResponse extends CognitoIdentityResponse implements
        ToCopyableBuilder<GetIdentityPoolRolesResponse.Builder, GetIdentityPoolRolesResponse> {
    private final String identityPoolId;

    private final Map<String, String> roles;

    private final Map<String, RoleMapping> roleMappings;

    private GetIdentityPoolRolesResponse(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.roles = builder.roles;
        this.roleMappings = builder.roleMappings;
    }

    /**
     * <p>
     * An identity pool ID in the format REGION:GUID.
     * </p>
     * 
     * @return An identity pool ID in the format REGION:GUID.
     */
    public String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * The map of roles associated with this pool. Currently only authenticated and unauthenticated roles are supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The map of roles associated with this pool. Currently only authenticated and unauthenticated roles are
     *         supported.
     */
    public Map<String, String> roles() {
        return roles;
    }

    /**
     * <p>
     * How users for a specific identity provider are to mapped to roles. This is a String-to-<a>RoleMapping</a> object
     * map. The string identifies the identity provider, for example, "graph.facebook.com" or
     * "cognito-idp-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return How users for a specific identity provider are to mapped to roles. This is a String-to-<a>RoleMapping</a>
     *         object map. The string identifies the identity provider, for example, "graph.facebook.com" or
     *         "cognito-idp-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".
     */
    public Map<String, RoleMapping> roleMappings() {
        return roleMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(roles());
        hashCode = 31 * hashCode + Objects.hashCode(roleMappings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityPoolRolesResponse)) {
            return false;
        }
        GetIdentityPoolRolesResponse other = (GetIdentityPoolRolesResponse) obj;
        return Objects.equals(identityPoolId(), other.identityPoolId()) && Objects.equals(roles(), other.roles())
                && Objects.equals(roleMappings(), other.roleMappings());
    }

    @Override
    public String toString() {
        return ToString.builder("GetIdentityPoolRolesResponse").add("IdentityPoolId", identityPoolId()).add("Roles", roles())
                .add("RoleMappings", roleMappings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPoolId":
            return Optional.of(clazz.cast(identityPoolId()));
        case "Roles":
            return Optional.of(clazz.cast(roles()));
        case "RoleMappings":
            return Optional.of(clazz.cast(roleMappings()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityResponse.Builder, CopyableBuilder<Builder, GetIdentityPoolRolesResponse> {
        /**
         * <p>
         * An identity pool ID in the format REGION:GUID.
         * </p>
         * 
         * @param identityPoolId
         *        An identity pool ID in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * The map of roles associated with this pool. Currently only authenticated and unauthenticated roles are
         * supported.
         * </p>
         * 
         * @param roles
         *        The map of roles associated with this pool. Currently only authenticated and unauthenticated roles are
         *        supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roles(Map<String, String> roles);

        /**
         * <p>
         * How users for a specific identity provider are to mapped to roles. This is a String-to-<a>RoleMapping</a>
         * object map. The string identifies the identity provider, for example, "graph.facebook.com" or
         * "cognito-idp-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".
         * </p>
         * 
         * @param roleMappings
         *        How users for a specific identity provider are to mapped to roles. This is a
         *        String-to-<a>RoleMapping</a> object map. The string identifies the identity provider, for example,
         *        "graph.facebook.com" or "cognito-idp-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleMappings(Map<String, RoleMapping> roleMappings);
    }

    static final class BuilderImpl extends CognitoIdentityResponse.BuilderImpl implements Builder {
        private String identityPoolId;

        private Map<String, String> roles;

        private Map<String, RoleMapping> roleMappings;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityPoolRolesResponse model) {
            identityPoolId(model.identityPoolId);
            roles(model.roles);
            roleMappings(model.roleMappings);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Map<String, String> getRoles() {
            return roles;
        }

        @Override
        public final Builder roles(Map<String, String> roles) {
            this.roles = RolesMapCopier.copy(roles);
            return this;
        }

        public final void setRoles(Map<String, String> roles) {
            this.roles = RolesMapCopier.copy(roles);
        }

        public final Map<String, RoleMapping.Builder> getRoleMappings() {
            return roleMappings != null ? CollectionUtils.mapValues(roleMappings, RoleMapping::toBuilder) : null;
        }

        @Override
        public final Builder roleMappings(Map<String, RoleMapping> roleMappings) {
            this.roleMappings = RoleMappingMapCopier.copy(roleMappings);
            return this;
        }

        public final void setRoleMappings(Map<String, RoleMapping.BuilderImpl> roleMappings) {
            this.roleMappings = RoleMappingMapCopier.copyFromBuilder(roleMappings);
        }

        @Override
        public GetIdentityPoolRolesResponse build() {
            return new GetIdentityPoolRolesResponse(this);
        }
    }
}
