/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to the GetOpenIdToken action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetOpenIdTokenRequest extends CognitoIdentityRequest implements
        ToCopyableBuilder<GetOpenIdTokenRequest.Builder, GetOpenIdTokenRequest> {
    private final String identityId;

    private final Map<String, String> logins;

    private GetOpenIdTokenRequest(BuilderImpl builder) {
        super(builder);
        this.identityId = builder.identityId;
        this.logins = builder.logins;
    }

    /**
     * <p>
     * A unique identifier in the format REGION:GUID.
     * </p>
     * 
     * @return A unique identifier in the format REGION:GUID.
     */
    public String identityId() {
        return identityId;
    }

    /**
     * <p>
     * A set of optional name-value pairs that map provider names to provider tokens. When using graph.facebook.com and
     * www.amazon.com, supply the access_token returned from the provider's authflow. For accounts.google.com, an Amazon
     * Cognito Identity Provider, or any other OpenId Connect provider, always include the <code>id_token</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A set of optional name-value pairs that map provider names to provider tokens. When using
     *         graph.facebook.com and www.amazon.com, supply the access_token returned from the provider's authflow. For
     *         accounts.google.com, an Amazon Cognito Identity Provider, or any other OpenId Connect provider, always
     *         include the <code>id_token</code>.
     */
    public Map<String, String> logins() {
        return logins;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityId());
        hashCode = 31 * hashCode + Objects.hashCode(logins());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpenIdTokenRequest)) {
            return false;
        }
        GetOpenIdTokenRequest other = (GetOpenIdTokenRequest) obj;
        return Objects.equals(identityId(), other.identityId()) && Objects.equals(logins(), other.logins());
    }

    @Override
    public String toString() {
        return ToString.builder("GetOpenIdTokenRequest").add("IdentityId", identityId()).add("Logins", logins()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityId":
            return Optional.of(clazz.cast(identityId()));
        case "Logins":
            return Optional.of(clazz.cast(logins()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityRequest.Builder, CopyableBuilder<Builder, GetOpenIdTokenRequest> {
        /**
         * <p>
         * A unique identifier in the format REGION:GUID.
         * </p>
         * 
         * @param identityId
         *        A unique identifier in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * A set of optional name-value pairs that map provider names to provider tokens. When using graph.facebook.com
         * and www.amazon.com, supply the access_token returned from the provider's authflow. For accounts.google.com,
         * an Amazon Cognito Identity Provider, or any other OpenId Connect provider, always include the
         * <code>id_token</code>.
         * </p>
         * 
         * @param logins
         *        A set of optional name-value pairs that map provider names to provider tokens. When using
         *        graph.facebook.com and www.amazon.com, supply the access_token returned from the provider's authflow.
         *        For accounts.google.com, an Amazon Cognito Identity Provider, or any other OpenId Connect provider,
         *        always include the <code>id_token</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logins(Map<String, String> logins);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends CognitoIdentityRequest.BuilderImpl implements Builder {
        private String identityId;

        private Map<String, String> logins;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpenIdTokenRequest model) {
            identityId(model.identityId);
            logins(model.logins);
        }

        public final String getIdentityId() {
            return identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final Map<String, String> getLogins() {
            return logins;
        }

        @Override
        public final Builder logins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
            return this;
        }

        public final void setLogins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetOpenIdTokenRequest build() {
            return new GetOpenIdTokenRequest(this);
        }
    }
}
