/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.transform;

import java.util.Map;
import java.util.List;
import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.cognitoidentity.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * CreateIdentityPoolRequestMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class CreateIdentityPoolRequestModelMarshaller {

    private static final MarshallingInfo<String> IDENTITYPOOLNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityPoolName").build();
    private static final MarshallingInfo<Boolean> ALLOWUNAUTHENTICATEDIDENTITIES_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("AllowUnauthenticatedIdentities").build();
    private static final MarshallingInfo<Map> SUPPORTEDLOGINPROVIDERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedLoginProviders").build();
    private static final MarshallingInfo<String> DEVELOPERPROVIDERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeveloperProviderName").build();
    private static final MarshallingInfo<List> OPENIDCONNECTPROVIDERARNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OpenIdConnectProviderARNs").build();
    private static final MarshallingInfo<List> COGNITOIDENTITYPROVIDERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CognitoIdentityProviders").build();
    private static final MarshallingInfo<List> SAMLPROVIDERARNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SamlProviderARNs").build();

    private static final CreateIdentityPoolRequestModelMarshaller INSTANCE = new CreateIdentityPoolRequestModelMarshaller();

    public static CreateIdentityPoolRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(CreateIdentityPoolRequest createIdentityPoolRequest, ProtocolMarshaller protocolMarshaller) {

        if (createIdentityPoolRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(createIdentityPoolRequest.identityPoolName(), IDENTITYPOOLNAME_BINDING);

            protocolMarshaller.marshall(createIdentityPoolRequest.allowUnauthenticatedIdentities(),
                    ALLOWUNAUTHENTICATEDIDENTITIES_BINDING);

            protocolMarshaller.marshall(createIdentityPoolRequest.supportedLoginProviders(), SUPPORTEDLOGINPROVIDERS_BINDING);

            protocolMarshaller.marshall(createIdentityPoolRequest.developerProviderName(), DEVELOPERPROVIDERNAME_BINDING);

            protocolMarshaller.marshall(createIdentityPoolRequest.openIdConnectProviderARNs(), OPENIDCONNECTPROVIDERARNS_BINDING);

            protocolMarshaller.marshall(createIdentityPoolRequest.cognitoIdentityProviders(), COGNITOIDENTITYPROVIDERS_BINDING);

            protocolMarshaller.marshall(createIdentityPoolRequest.samlProviderARNs(), SAMLPROVIDERARNS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
