/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response to a ListIdentities request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIdentitiesResponse extends CognitoIdentityResponse implements
        ToCopyableBuilder<ListIdentitiesResponse.Builder, ListIdentitiesResponse> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListIdentitiesResponse::identityPoolId)).setter(setter(Builder::identityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()).build();

    private static final SdkField<List<IdentityDescription>> IDENTITIES_FIELD = SdkField
            .<List<IdentityDescription>> builder(MarshallingType.LIST)
            .getter(getter(ListIdentitiesResponse::identities))
            .setter(setter(Builder::identities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdentityDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdentityDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListIdentitiesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD,
            IDENTITIES_FIELD, NEXT_TOKEN_FIELD));

    private final String identityPoolId;

    private final List<IdentityDescription> identities;

    private final String nextToken;

    private ListIdentitiesResponse(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identities = builder.identities;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An identity pool ID in the format REGION:GUID.
     * </p>
     * 
     * @return An identity pool ID in the format REGION:GUID.
     */
    public String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * An object containing a set of identities and associated mappings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An object containing a set of identities and associated mappings.
     */
    public List<IdentityDescription> identities() {
        return identities;
    }

    /**
     * <p>
     * A pagination token.
     * </p>
     * 
     * @return A pagination token.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(identities());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentitiesResponse)) {
            return false;
        }
        ListIdentitiesResponse other = (ListIdentitiesResponse) obj;
        return Objects.equals(identityPoolId(), other.identityPoolId()) && Objects.equals(identities(), other.identities())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListIdentitiesResponse").add("IdentityPoolId", identityPoolId()).add("Identities", identities())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPoolId":
            return Optional.ofNullable(clazz.cast(identityPoolId()));
        case "Identities":
            return Optional.ofNullable(clazz.cast(identities()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIdentitiesResponse, T> g) {
        return obj -> g.apply((ListIdentitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListIdentitiesResponse> {
        /**
         * <p>
         * An identity pool ID in the format REGION:GUID.
         * </p>
         * 
         * @param identityPoolId
         *        An identity pool ID in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * An object containing a set of identities and associated mappings.
         * </p>
         * 
         * @param identities
         *        An object containing a set of identities and associated mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identities(Collection<IdentityDescription> identities);

        /**
         * <p>
         * An object containing a set of identities and associated mappings.
         * </p>
         * 
         * @param identities
         *        An object containing a set of identities and associated mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identities(IdentityDescription... identities);

        /**
         * <p>
         * An object containing a set of identities and associated mappings.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IdentityDescription>.Builder} avoiding the
         * need to create one manually via {@link List<IdentityDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IdentityDescription>.Builder#build()} is called immediately
         * and its result is passed to {@link #identities(List<IdentityDescription>)}.
         * 
         * @param identities
         *        a consumer that will call methods on {@link List<IdentityDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identities(List<IdentityDescription>)
         */
        Builder identities(Consumer<IdentityDescription.Builder>... identities);

        /**
         * <p>
         * A pagination token.
         * </p>
         * 
         * @param nextToken
         *        A pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CognitoIdentityResponse.BuilderImpl implements Builder {
        private String identityPoolId;

        private List<IdentityDescription> identities = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentitiesResponse model) {
            super(model);
            identityPoolId(model.identityPoolId);
            identities(model.identities);
            nextToken(model.nextToken);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Collection<IdentityDescription.Builder> getIdentities() {
            return identities != null ? identities.stream().map(IdentityDescription::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder identities(Collection<IdentityDescription> identities) {
            this.identities = IdentitiesListCopier.copy(identities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identities(IdentityDescription... identities) {
            identities(Arrays.asList(identities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identities(Consumer<IdentityDescription.Builder>... identities) {
            identities(Stream.of(identities).map(c -> IdentityDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIdentities(Collection<IdentityDescription.BuilderImpl> identities) {
            this.identities = IdentitiesListCopier.copyFromBuilder(identities);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIdentitiesResponse build() {
            return new ListIdentitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
