/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A role mapping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoleMapping implements SdkPojo, Serializable, ToCopyableBuilder<RoleMapping.Builder, RoleMapping> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RoleMapping::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> AMBIGUOUS_ROLE_RESOLUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RoleMapping::ambiguousRoleResolutionAsString)).setter(setter(Builder::ambiguousRoleResolution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmbiguousRoleResolution").build())
            .build();

    private static final SdkField<RulesConfigurationType> RULES_CONFIGURATION_FIELD = SdkField
            .<RulesConfigurationType> builder(MarshallingType.SDK_POJO).getter(getter(RoleMapping::rulesConfiguration))
            .setter(setter(Builder::rulesConfiguration)).constructor(RulesConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            AMBIGUOUS_ROLE_RESOLUTION_FIELD, RULES_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String ambiguousRoleResolution;

    private final RulesConfigurationType rulesConfiguration;

    private RoleMapping(BuilderImpl builder) {
        this.type = builder.type;
        this.ambiguousRoleResolution = builder.ambiguousRoleResolution;
        this.rulesConfiguration = builder.rulesConfiguration;
    }

    /**
     * <p>
     * The role mapping type. Token will use <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims
     * from the Cognito identity provider token to map groups to roles. Rules will attempt to match claims from the
     * token to map to a role.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RoleMappingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The role mapping type. Token will use <code>cognito:roles</code> and <code>cognito:preferred_role</code>
     *         claims from the Cognito identity provider token to map groups to roles. Rules will attempt to match
     *         claims from the token to map to a role.
     * @see RoleMappingType
     */
    public RoleMappingType type() {
        return RoleMappingType.fromValue(type);
    }

    /**
     * <p>
     * The role mapping type. Token will use <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims
     * from the Cognito identity provider token to map groups to roles. Rules will attempt to match claims from the
     * token to map to a role.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RoleMappingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The role mapping type. Token will use <code>cognito:roles</code> and <code>cognito:preferred_role</code>
     *         claims from the Cognito identity provider token to map groups to roles. Rules will attempt to match
     *         claims from the token to map to a role.
     * @see RoleMappingType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * If you specify Token or Rules as the <code>Type</code>, <code>AmbiguousRoleResolution</code> is required.
     * </p>
     * <p>
     * Specifies the action to be taken if either no rules match the claim value for the <code>Rules</code> type, or
     * there is no <code>cognito:preferred_role</code> claim and there are multiple <code>cognito:roles</code> matches
     * for the <code>Token</code> type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ambiguousRoleResolution} will return {@link AmbiguousRoleResolutionType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #ambiguousRoleResolutionAsString}.
     * </p>
     * 
     * @return If you specify Token or Rules as the <code>Type</code>, <code>AmbiguousRoleResolution</code> is
     *         required.</p>
     *         <p>
     *         Specifies the action to be taken if either no rules match the claim value for the <code>Rules</code>
     *         type, or there is no <code>cognito:preferred_role</code> claim and there are multiple
     *         <code>cognito:roles</code> matches for the <code>Token</code> type.
     * @see AmbiguousRoleResolutionType
     */
    public AmbiguousRoleResolutionType ambiguousRoleResolution() {
        return AmbiguousRoleResolutionType.fromValue(ambiguousRoleResolution);
    }

    /**
     * <p>
     * If you specify Token or Rules as the <code>Type</code>, <code>AmbiguousRoleResolution</code> is required.
     * </p>
     * <p>
     * Specifies the action to be taken if either no rules match the claim value for the <code>Rules</code> type, or
     * there is no <code>cognito:preferred_role</code> claim and there are multiple <code>cognito:roles</code> matches
     * for the <code>Token</code> type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ambiguousRoleResolution} will return {@link AmbiguousRoleResolutionType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #ambiguousRoleResolutionAsString}.
     * </p>
     * 
     * @return If you specify Token or Rules as the <code>Type</code>, <code>AmbiguousRoleResolution</code> is
     *         required.</p>
     *         <p>
     *         Specifies the action to be taken if either no rules match the claim value for the <code>Rules</code>
     *         type, or there is no <code>cognito:preferred_role</code> claim and there are multiple
     *         <code>cognito:roles</code> matches for the <code>Token</code> type.
     * @see AmbiguousRoleResolutionType
     */
    public String ambiguousRoleResolutionAsString() {
        return ambiguousRoleResolution;
    }

    /**
     * <p>
     * The rules to be used for mapping users to roles.
     * </p>
     * <p>
     * If you specify Rules as the role mapping type, <code>RulesConfiguration</code> is required.
     * </p>
     * 
     * @return The rules to be used for mapping users to roles.</p>
     *         <p>
     *         If you specify Rules as the role mapping type, <code>RulesConfiguration</code> is required.
     */
    public RulesConfigurationType rulesConfiguration() {
        return rulesConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ambiguousRoleResolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rulesConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleMapping)) {
            return false;
        }
        RoleMapping other = (RoleMapping) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(ambiguousRoleResolutionAsString(), other.ambiguousRoleResolutionAsString())
                && Objects.equals(rulesConfiguration(), other.rulesConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RoleMapping").add("Type", typeAsString())
                .add("AmbiguousRoleResolution", ambiguousRoleResolutionAsString())
                .add("RulesConfiguration", rulesConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "AmbiguousRoleResolution":
            return Optional.ofNullable(clazz.cast(ambiguousRoleResolutionAsString()));
        case "RulesConfiguration":
            return Optional.ofNullable(clazz.cast(rulesConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RoleMapping, T> g) {
        return obj -> g.apply((RoleMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoleMapping> {
        /**
         * <p>
         * The role mapping type. Token will use <code>cognito:roles</code> and <code>cognito:preferred_role</code>
         * claims from the Cognito identity provider token to map groups to roles. Rules will attempt to match claims
         * from the token to map to a role.
         * </p>
         * 
         * @param type
         *        The role mapping type. Token will use <code>cognito:roles</code> and
         *        <code>cognito:preferred_role</code> claims from the Cognito identity provider token to map groups to
         *        roles. Rules will attempt to match claims from the token to map to a role.
         * @see RoleMappingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoleMappingType
         */
        Builder type(String type);

        /**
         * <p>
         * The role mapping type. Token will use <code>cognito:roles</code> and <code>cognito:preferred_role</code>
         * claims from the Cognito identity provider token to map groups to roles. Rules will attempt to match claims
         * from the token to map to a role.
         * </p>
         * 
         * @param type
         *        The role mapping type. Token will use <code>cognito:roles</code> and
         *        <code>cognito:preferred_role</code> claims from the Cognito identity provider token to map groups to
         *        roles. Rules will attempt to match claims from the token to map to a role.
         * @see RoleMappingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoleMappingType
         */
        Builder type(RoleMappingType type);

        /**
         * <p>
         * If you specify Token or Rules as the <code>Type</code>, <code>AmbiguousRoleResolution</code> is required.
         * </p>
         * <p>
         * Specifies the action to be taken if either no rules match the claim value for the <code>Rules</code> type, or
         * there is no <code>cognito:preferred_role</code> claim and there are multiple <code>cognito:roles</code>
         * matches for the <code>Token</code> type.
         * </p>
         * 
         * @param ambiguousRoleResolution
         *        If you specify Token or Rules as the <code>Type</code>, <code>AmbiguousRoleResolution</code> is
         *        required.</p>
         *        <p>
         *        Specifies the action to be taken if either no rules match the claim value for the <code>Rules</code>
         *        type, or there is no <code>cognito:preferred_role</code> claim and there are multiple
         *        <code>cognito:roles</code> matches for the <code>Token</code> type.
         * @see AmbiguousRoleResolutionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AmbiguousRoleResolutionType
         */
        Builder ambiguousRoleResolution(String ambiguousRoleResolution);

        /**
         * <p>
         * If you specify Token or Rules as the <code>Type</code>, <code>AmbiguousRoleResolution</code> is required.
         * </p>
         * <p>
         * Specifies the action to be taken if either no rules match the claim value for the <code>Rules</code> type, or
         * there is no <code>cognito:preferred_role</code> claim and there are multiple <code>cognito:roles</code>
         * matches for the <code>Token</code> type.
         * </p>
         * 
         * @param ambiguousRoleResolution
         *        If you specify Token or Rules as the <code>Type</code>, <code>AmbiguousRoleResolution</code> is
         *        required.</p>
         *        <p>
         *        Specifies the action to be taken if either no rules match the claim value for the <code>Rules</code>
         *        type, or there is no <code>cognito:preferred_role</code> claim and there are multiple
         *        <code>cognito:roles</code> matches for the <code>Token</code> type.
         * @see AmbiguousRoleResolutionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AmbiguousRoleResolutionType
         */
        Builder ambiguousRoleResolution(AmbiguousRoleResolutionType ambiguousRoleResolution);

        /**
         * <p>
         * The rules to be used for mapping users to roles.
         * </p>
         * <p>
         * If you specify Rules as the role mapping type, <code>RulesConfiguration</code> is required.
         * </p>
         * 
         * @param rulesConfiguration
         *        The rules to be used for mapping users to roles.</p>
         *        <p>
         *        If you specify Rules as the role mapping type, <code>RulesConfiguration</code> is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesConfiguration(RulesConfigurationType rulesConfiguration);

        /**
         * <p>
         * The rules to be used for mapping users to roles.
         * </p>
         * <p>
         * If you specify Rules as the role mapping type, <code>RulesConfiguration</code> is required.
         * </p>
         * This is a convenience that creates an instance of the {@link RulesConfigurationType.Builder} avoiding the
         * need to create one manually via {@link RulesConfigurationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link RulesConfigurationType.Builder#build()} is called immediately and
         * its result is passed to {@link #rulesConfiguration(RulesConfigurationType)}.
         * 
         * @param rulesConfiguration
         *        a consumer that will call methods on {@link RulesConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rulesConfiguration(RulesConfigurationType)
         */
        default Builder rulesConfiguration(Consumer<RulesConfigurationType.Builder> rulesConfiguration) {
            return rulesConfiguration(RulesConfigurationType.builder().applyMutation(rulesConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String ambiguousRoleResolution;

        private RulesConfigurationType rulesConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RoleMapping model) {
            type(model.type);
            ambiguousRoleResolution(model.ambiguousRoleResolution);
            rulesConfiguration(model.rulesConfiguration);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RoleMappingType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getAmbiguousRoleResolution() {
            return ambiguousRoleResolution;
        }

        @Override
        public final Builder ambiguousRoleResolution(String ambiguousRoleResolution) {
            this.ambiguousRoleResolution = ambiguousRoleResolution;
            return this;
        }

        @Override
        public final Builder ambiguousRoleResolution(AmbiguousRoleResolutionType ambiguousRoleResolution) {
            this.ambiguousRoleResolution(ambiguousRoleResolution == null ? null : ambiguousRoleResolution.toString());
            return this;
        }

        public final void setAmbiguousRoleResolution(String ambiguousRoleResolution) {
            this.ambiguousRoleResolution = ambiguousRoleResolution;
        }

        public final RulesConfigurationType.Builder getRulesConfiguration() {
            return rulesConfiguration != null ? rulesConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder rulesConfiguration(RulesConfigurationType rulesConfiguration) {
            this.rulesConfiguration = rulesConfiguration;
            return this;
        }

        public final void setRulesConfiguration(RulesConfigurationType.BuilderImpl rulesConfiguration) {
            this.rulesConfiguration = rulesConfiguration != null ? rulesConfiguration.build() : null;
        }

        @Override
        public RoleMapping build() {
            return new RoleMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
