/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOpenIdTokenForDeveloperIdentityResponse
extends CognitoIdentityResponse
implements ToCopyableBuilder<Builder, GetOpenIdTokenForDeveloperIdentityResponse> {
    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetOpenIdTokenForDeveloperIdentityResponse.getter(GetOpenIdTokenForDeveloperIdentityResponse::identityId)).setter(GetOpenIdTokenForDeveloperIdentityResponse.setter(Builder::identityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityId").build()}).build();
    private static final SdkField<String> TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetOpenIdTokenForDeveloperIdentityResponse.getter(GetOpenIdTokenForDeveloperIdentityResponse::token)).setter(GetOpenIdTokenForDeveloperIdentityResponse.setter(Builder::token)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Token").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_ID_FIELD, TOKEN_FIELD));
    private final String identityId;
    private final String token;

    private GetOpenIdTokenForDeveloperIdentityResponse(BuilderImpl builder) {
        super(builder);
        this.identityId = builder.identityId;
        this.token = builder.token;
    }

    public String identityId() {
        return this.identityId;
    }

    public String token() {
        return this.token;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpenIdTokenForDeveloperIdentityResponse)) {
            return false;
        }
        GetOpenIdTokenForDeveloperIdentityResponse other = (GetOpenIdTokenForDeveloperIdentityResponse)((Object)obj);
        return Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.token(), other.token());
    }

    public String toString() {
        return ToString.builder((String)"GetOpenIdTokenForDeveloperIdentityResponse").add("IdentityId", (Object)this.identityId()).add("Token", (Object)this.token()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityId": {
                return Optional.ofNullable(clazz.cast(this.identityId()));
            }
            case "Token": {
                return Optional.ofNullable(clazz.cast(this.token()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOpenIdTokenForDeveloperIdentityResponse, T> g) {
        return obj -> g.apply((GetOpenIdTokenForDeveloperIdentityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityResponse.BuilderImpl
    implements Builder {
        private String identityId;
        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpenIdTokenForDeveloperIdentityResponse model) {
            super(model);
            this.identityId(model.identityId);
            this.token(model.token);
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getToken() {
            return this.token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public GetOpenIdTokenForDeveloperIdentityResponse build() {
            return new GetOpenIdTokenForDeveloperIdentityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOpenIdTokenForDeveloperIdentityResponse> {
        public Builder identityId(String var1);

        public Builder token(String var1);
    }
}

