/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.cognitoidentity.model.CreateIdentityPoolRequest;
import software.amazon.awssdk.services.cognitoidentity.model.CreateIdentityPoolResponse;
import software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentitiesRequest;
import software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentitiesResponse;
import software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentityPoolRequest;
import software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentityPoolResponse;
import software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityPoolRequest;
import software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityPoolResponse;
import software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdentityPoolRolesRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdentityPoolRolesResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetPrincipalTagAttributeMapRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetPrincipalTagAttributeMapResponse;
import software.amazon.awssdk.services.cognitoidentity.model.ListIdentitiesRequest;
import software.amazon.awssdk.services.cognitoidentity.model.ListIdentitiesResponse;
import software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest;
import software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsResponse;
import software.amazon.awssdk.services.cognitoidentity.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cognitoidentity.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.MergeDeveloperIdentitiesRequest;
import software.amazon.awssdk.services.cognitoidentity.model.MergeDeveloperIdentitiesResponse;
import software.amazon.awssdk.services.cognitoidentity.model.SetIdentityPoolRolesRequest;
import software.amazon.awssdk.services.cognitoidentity.model.SetIdentityPoolRolesResponse;
import software.amazon.awssdk.services.cognitoidentity.model.SetPrincipalTagAttributeMapRequest;
import software.amazon.awssdk.services.cognitoidentity.model.SetPrincipalTagAttributeMapResponse;
import software.amazon.awssdk.services.cognitoidentity.model.TagResourceRequest;
import software.amazon.awssdk.services.cognitoidentity.model.TagResourceResponse;
import software.amazon.awssdk.services.cognitoidentity.model.UnlinkDeveloperIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.UnlinkDeveloperIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.UnlinkIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.UnlinkIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.UntagResourceRequest;
import software.amazon.awssdk.services.cognitoidentity.model.UntagResourceResponse;
import software.amazon.awssdk.services.cognitoidentity.model.UpdateIdentityPoolRequest;
import software.amazon.awssdk.services.cognitoidentity.model.UpdateIdentityPoolResponse;
import software.amazon.awssdk.services.cognitoidentity.paginators.ListIdentityPoolsPublisher;

/**
 * Service client for accessing Amazon Cognito Identity asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname>Amazon Cognito Federated Identities</fullname>
 * <p>
 * Amazon Cognito Federated Identities is a web service that delivers scoped temporary credentials to mobile devices and
 * other untrusted environments. It uniquely identifies a device and supplies the user with a consistent identity over
 * the lifetime of an application.
 * </p>
 * <p>
 * Using Amazon Cognito Federated Identities, you can enable authentication with one or more third-party identity
 * providers (Facebook, Google, or Login with Amazon) or an Amazon Cognito user pool, and you can also choose to support
 * unauthenticated access from your app. Cognito delivers a unique identifier for each user and acts as an OpenID token
 * provider trusted by AWS Security Token Service (STS) to access temporary, limited-privilege AWS credentials.
 * </p>
 * <p>
 * For a description of the authentication flow from the Amazon Cognito Developer Guide see <a
 * href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Authentication Flow</a>.
 * </p>
 * <p>
 * For more information see <a
 * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-identity.html">Amazon Cognito Federated
 * Identities</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface CognitoIdentityAsyncClient extends SdkClient {
    String SERVICE_NAME = "cognito-identity";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cognito-identity";

    /**
     * Create a {@link CognitoIdentityAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CognitoIdentityAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CognitoIdentityAsyncClient}.
     */
    static CognitoIdentityAsyncClientBuilder builder() {
        return new DefaultCognitoIdentityAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates a new identity pool. The identity pool is a store of user identity information that is specific to your
     * AWS account. The keys for <code>SupportedLoginProviders</code> are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Facebook: <code>graph.facebook.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Google: <code>accounts.google.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon: <code>www.amazon.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Twitter: <code>api.twitter.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Digits: <code>www.digits.com</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     *
     * @param createIdentityPoolRequest
     *        Input to the CreateIdentityPool action.
     * @return A Java Future containing the result of the CreateIdentityPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>LimitExceededException Thrown when the total number of user pools has exceeded a preset limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.CreateIdentityPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/CreateIdentityPool"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIdentityPoolResponse> createIdentityPool(CreateIdentityPoolRequest createIdentityPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new identity pool. The identity pool is a store of user identity information that is specific to your
     * AWS account. The keys for <code>SupportedLoginProviders</code> are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Facebook: <code>graph.facebook.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Google: <code>accounts.google.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon: <code>www.amazon.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Twitter: <code>api.twitter.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Digits: <code>www.digits.com</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIdentityPoolRequest.Builder} avoiding the
     * need to create one manually via {@link CreateIdentityPoolRequest#builder()}
     * </p>
     *
     * @param createIdentityPoolRequest
     *        A {@link Consumer} that will call methods on {@link CreateIdentityPoolInput.Builder} to create a request.
     *        Input to the CreateIdentityPool action.
     * @return A Java Future containing the result of the CreateIdentityPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>LimitExceededException Thrown when the total number of user pools has exceeded a preset limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.CreateIdentityPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/CreateIdentityPool"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIdentityPoolResponse> createIdentityPool(
            Consumer<CreateIdentityPoolRequest.Builder> createIdentityPoolRequest) {
        return createIdentityPool(CreateIdentityPoolRequest.builder().applyMutation(createIdentityPoolRequest).build());
    }

    /**
     * <p>
     * Deletes identities from an identity pool. You can specify a list of 1-60 identities that you want to delete.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     *
     * @param deleteIdentitiesRequest
     *        Input to the <code>DeleteIdentities</code> action.
     * @return A Java Future containing the result of the DeleteIdentities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.DeleteIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/DeleteIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIdentitiesResponse> deleteIdentities(DeleteIdentitiesRequest deleteIdentitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes identities from an identity pool. You can specify a list of 1-60 identities that you want to delete.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIdentitiesRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteIdentitiesRequest#builder()}
     * </p>
     *
     * @param deleteIdentitiesRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIdentitiesInput.Builder} to create a request.
     *        Input to the <code>DeleteIdentities</code> action.
     * @return A Java Future containing the result of the DeleteIdentities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.DeleteIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/DeleteIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIdentitiesResponse> deleteIdentities(
            Consumer<DeleteIdentitiesRequest.Builder> deleteIdentitiesRequest) {
        return deleteIdentities(DeleteIdentitiesRequest.builder().applyMutation(deleteIdentitiesRequest).build());
    }

    /**
     * <p>
     * Deletes an identity pool. Once a pool is deleted, users will not be able to authenticate with the pool.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     *
     * @param deleteIdentityPoolRequest
     *        Input to the DeleteIdentityPool action.
     * @return A Java Future containing the result of the DeleteIdentityPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.DeleteIdentityPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/DeleteIdentityPool"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIdentityPoolResponse> deleteIdentityPool(DeleteIdentityPoolRequest deleteIdentityPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an identity pool. Once a pool is deleted, users will not be able to authenticate with the pool.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIdentityPoolRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteIdentityPoolRequest#builder()}
     * </p>
     *
     * @param deleteIdentityPoolRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIdentityPoolInput.Builder} to create a request.
     *        Input to the DeleteIdentityPool action.
     * @return A Java Future containing the result of the DeleteIdentityPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.DeleteIdentityPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/DeleteIdentityPool"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIdentityPoolResponse> deleteIdentityPool(
            Consumer<DeleteIdentityPoolRequest.Builder> deleteIdentityPoolRequest) {
        return deleteIdentityPool(DeleteIdentityPoolRequest.builder().applyMutation(deleteIdentityPoolRequest).build());
    }

    /**
     * <p>
     * Returns metadata related to the given identity, including when the identity was created and any associated linked
     * logins.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     *
     * @param describeIdentityRequest
     *        Input to the <code>DescribeIdentity</code> action.
     * @return A Java Future containing the result of the DescribeIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.DescribeIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/DescribeIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeIdentityResponse> describeIdentity(DescribeIdentityRequest describeIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata related to the given identity, including when the identity was created and any associated linked
     * logins.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIdentityRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeIdentityRequest#builder()}
     * </p>
     *
     * @param describeIdentityRequest
     *        A {@link Consumer} that will call methods on {@link DescribeIdentityInput.Builder} to create a request.
     *        Input to the <code>DescribeIdentity</code> action.
     * @return A Java Future containing the result of the DescribeIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.DescribeIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/DescribeIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeIdentityResponse> describeIdentity(
            Consumer<DescribeIdentityRequest.Builder> describeIdentityRequest) {
        return describeIdentity(DescribeIdentityRequest.builder().applyMutation(describeIdentityRequest).build());
    }

    /**
     * <p>
     * Gets details about a particular identity pool, including the pool name, ID description, creation date, and
     * current number of users.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     *
     * @param describeIdentityPoolRequest
     *        Input to the DescribeIdentityPool action.
     * @return A Java Future containing the result of the DescribeIdentityPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.DescribeIdentityPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/DescribeIdentityPool"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeIdentityPoolResponse> describeIdentityPool(
            DescribeIdentityPoolRequest describeIdentityPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a particular identity pool, including the pool name, ID description, creation date, and
     * current number of users.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIdentityPoolRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeIdentityPoolRequest#builder()}
     * </p>
     *
     * @param describeIdentityPoolRequest
     *        A {@link Consumer} that will call methods on {@link DescribeIdentityPoolInput.Builder} to create a
     *        request. Input to the DescribeIdentityPool action.
     * @return A Java Future containing the result of the DescribeIdentityPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.DescribeIdentityPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/DescribeIdentityPool"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeIdentityPoolResponse> describeIdentityPool(
            Consumer<DescribeIdentityPoolRequest.Builder> describeIdentityPoolRequest) {
        return describeIdentityPool(DescribeIdentityPoolRequest.builder().applyMutation(describeIdentityPoolRequest).build());
    }

    /**
     * <p>
     * Returns credentials for the provided identity ID. Any provided logins will be validated against supported login
     * providers. If the token is for cognito-identity.amazonaws.com, it will be passed through to AWS Security Token
     * Service with the appropriate role for the token.
     * </p>
     * <p>
     * This is a public API. You do not need any credentials to call this API.
     * </p>
     *
     * @param getCredentialsForIdentityRequest
     *        Input to the <code>GetCredentialsForIdentity</code> action.
     * @return A Java Future containing the result of the GetCredentialsForIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InvalidIdentityPoolConfigurationException Thrown if the identity pool has no role associated for the
     *         given auth type (auth/unauth) or if the AssumeRole fails.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>ExternalServiceException An exception thrown when a dependent service such as Facebook or Twitter is
     *         not responding</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.GetCredentialsForIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetCredentialsForIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCredentialsForIdentityResponse> getCredentialsForIdentity(
            GetCredentialsForIdentityRequest getCredentialsForIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns credentials for the provided identity ID. Any provided logins will be validated against supported login
     * providers. If the token is for cognito-identity.amazonaws.com, it will be passed through to AWS Security Token
     * Service with the appropriate role for the token.
     * </p>
     * <p>
     * This is a public API. You do not need any credentials to call this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCredentialsForIdentityRequest.Builder} avoiding
     * the need to create one manually via {@link GetCredentialsForIdentityRequest#builder()}
     * </p>
     *
     * @param getCredentialsForIdentityRequest
     *        A {@link Consumer} that will call methods on {@link GetCredentialsForIdentityInput.Builder} to create a
     *        request. Input to the <code>GetCredentialsForIdentity</code> action.
     * @return A Java Future containing the result of the GetCredentialsForIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InvalidIdentityPoolConfigurationException Thrown if the identity pool has no role associated for the
     *         given auth type (auth/unauth) or if the AssumeRole fails.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>ExternalServiceException An exception thrown when a dependent service such as Facebook or Twitter is
     *         not responding</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.GetCredentialsForIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetCredentialsForIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCredentialsForIdentityResponse> getCredentialsForIdentity(
            Consumer<GetCredentialsForIdentityRequest.Builder> getCredentialsForIdentityRequest) {
        return getCredentialsForIdentity(GetCredentialsForIdentityRequest.builder()
                .applyMutation(getCredentialsForIdentityRequest).build());
    }

    /**
     * <p>
     * Generates (or retrieves) a Cognito ID. Supplying multiple logins will create an implicit linked account.
     * </p>
     * <p>
     * This is a public API. You do not need any credentials to call this API.
     * </p>
     *
     * @param getIdRequest
     *        Input to the GetId action.
     * @return A Java Future containing the result of the GetId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>LimitExceededException Thrown when the total number of user pools has exceeded a preset limit.</li>
     *         <li>ExternalServiceException An exception thrown when a dependent service such as Facebook or Twitter is
     *         not responding</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.GetId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetId" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetIdResponse> getId(GetIdRequest getIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates (or retrieves) a Cognito ID. Supplying multiple logins will create an implicit linked account.
     * </p>
     * <p>
     * This is a public API. You do not need any credentials to call this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdRequest.Builder} avoiding the need to create
     * one manually via {@link GetIdRequest#builder()}
     * </p>
     *
     * @param getIdRequest
     *        A {@link Consumer} that will call methods on {@link GetIdInput.Builder} to create a request. Input to the
     *        GetId action.
     * @return A Java Future containing the result of the GetId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>LimitExceededException Thrown when the total number of user pools has exceeded a preset limit.</li>
     *         <li>ExternalServiceException An exception thrown when a dependent service such as Facebook or Twitter is
     *         not responding</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.GetId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetId" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetIdResponse> getId(Consumer<GetIdRequest.Builder> getIdRequest) {
        return getId(GetIdRequest.builder().applyMutation(getIdRequest).build());
    }

    /**
     * <p>
     * Gets the roles for an identity pool.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     *
     * @param getIdentityPoolRolesRequest
     *        Input to the <code>GetIdentityPoolRoles</code> action.
     * @return A Java Future containing the result of the GetIdentityPoolRoles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.GetIdentityPoolRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetIdentityPoolRoles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdentityPoolRolesResponse> getIdentityPoolRoles(
            GetIdentityPoolRolesRequest getIdentityPoolRolesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the roles for an identity pool.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdentityPoolRolesRequest.Builder} avoiding the
     * need to create one manually via {@link GetIdentityPoolRolesRequest#builder()}
     * </p>
     *
     * @param getIdentityPoolRolesRequest
     *        A {@link Consumer} that will call methods on {@link GetIdentityPoolRolesInput.Builder} to create a
     *        request. Input to the <code>GetIdentityPoolRoles</code> action.
     * @return A Java Future containing the result of the GetIdentityPoolRoles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.GetIdentityPoolRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetIdentityPoolRoles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdentityPoolRolesResponse> getIdentityPoolRoles(
            Consumer<GetIdentityPoolRolesRequest.Builder> getIdentityPoolRolesRequest) {
        return getIdentityPoolRoles(GetIdentityPoolRolesRequest.builder().applyMutation(getIdentityPoolRolesRequest).build());
    }

    /**
     * <p>
     * Gets an OpenID token, using a known Cognito ID. This known Cognito ID is returned by <a>GetId</a>. You can
     * optionally add additional logins for the identity. Supplying multiple logins creates an implicit link.
     * </p>
     * <p>
     * The OpenID token is valid for 10 minutes.
     * </p>
     * <p>
     * This is a public API. You do not need any credentials to call this API.
     * </p>
     *
     * @param getOpenIdTokenRequest
     *        Input to the GetOpenIdToken action.
     * @return A Java Future containing the result of the GetOpenIdToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>ExternalServiceException An exception thrown when a dependent service such as Facebook or Twitter is
     *         not responding</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.GetOpenIdToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetOpenIdToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOpenIdTokenResponse> getOpenIdToken(GetOpenIdTokenRequest getOpenIdTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an OpenID token, using a known Cognito ID. This known Cognito ID is returned by <a>GetId</a>. You can
     * optionally add additional logins for the identity. Supplying multiple logins creates an implicit link.
     * </p>
     * <p>
     * The OpenID token is valid for 10 minutes.
     * </p>
     * <p>
     * This is a public API. You do not need any credentials to call this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOpenIdTokenRequest.Builder} avoiding the need to
     * create one manually via {@link GetOpenIdTokenRequest#builder()}
     * </p>
     *
     * @param getOpenIdTokenRequest
     *        A {@link Consumer} that will call methods on {@link GetOpenIdTokenInput.Builder} to create a request.
     *        Input to the GetOpenIdToken action.
     * @return A Java Future containing the result of the GetOpenIdToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>ExternalServiceException An exception thrown when a dependent service such as Facebook or Twitter is
     *         not responding</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.GetOpenIdToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetOpenIdToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOpenIdTokenResponse> getOpenIdToken(Consumer<GetOpenIdTokenRequest.Builder> getOpenIdTokenRequest) {
        return getOpenIdToken(GetOpenIdTokenRequest.builder().applyMutation(getOpenIdTokenRequest).build());
    }

    /**
     * <p>
     * Registers (or retrieves) a Cognito <code>IdentityId</code> and an OpenID Connect token for a user authenticated
     * by your backend authentication process. Supplying multiple logins will create an implicit linked account. You can
     * only specify one developer provider as part of the <code>Logins</code> map, which is linked to the identity pool.
     * The developer provider is the "domain" by which Cognito will refer to your users.
     * </p>
     * <p>
     * You can use <code>GetOpenIdTokenForDeveloperIdentity</code> to create a new identity and to link new logins (that
     * is, user credentials issued by a public provider or developer provider) to an existing identity. When you want to
     * create a new identity, the <code>IdentityId</code> should be null. When you want to associate a new login with an
     * existing authenticated/unauthenticated identity, you can do so by providing the existing <code>IdentityId</code>.
     * This API will create the identity in the specified <code>IdentityPoolId</code>.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     *
     * @param getOpenIdTokenForDeveloperIdentityRequest
     *        Input to the <code>GetOpenIdTokenForDeveloperIdentity</code> action.
     * @return A Java Future containing the result of the GetOpenIdTokenForDeveloperIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>DeveloperUserAlreadyRegisteredException The provided developer user identifier is already registered
     *         with Cognito under a different identity ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.GetOpenIdTokenForDeveloperIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetOpenIdTokenForDeveloperIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOpenIdTokenForDeveloperIdentityResponse> getOpenIdTokenForDeveloperIdentity(
            GetOpenIdTokenForDeveloperIdentityRequest getOpenIdTokenForDeveloperIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers (or retrieves) a Cognito <code>IdentityId</code> and an OpenID Connect token for a user authenticated
     * by your backend authentication process. Supplying multiple logins will create an implicit linked account. You can
     * only specify one developer provider as part of the <code>Logins</code> map, which is linked to the identity pool.
     * The developer provider is the "domain" by which Cognito will refer to your users.
     * </p>
     * <p>
     * You can use <code>GetOpenIdTokenForDeveloperIdentity</code> to create a new identity and to link new logins (that
     * is, user credentials issued by a public provider or developer provider) to an existing identity. When you want to
     * create a new identity, the <code>IdentityId</code> should be null. When you want to associate a new login with an
     * existing authenticated/unauthenticated identity, you can do so by providing the existing <code>IdentityId</code>.
     * This API will create the identity in the specified <code>IdentityPoolId</code>.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOpenIdTokenForDeveloperIdentityRequest.Builder}
     * avoiding the need to create one manually via {@link GetOpenIdTokenForDeveloperIdentityRequest#builder()}
     * </p>
     *
     * @param getOpenIdTokenForDeveloperIdentityRequest
     *        A {@link Consumer} that will call methods on {@link GetOpenIdTokenForDeveloperIdentityInput.Builder} to
     *        create a request. Input to the <code>GetOpenIdTokenForDeveloperIdentity</code> action.
     * @return A Java Future containing the result of the GetOpenIdTokenForDeveloperIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>DeveloperUserAlreadyRegisteredException The provided developer user identifier is already registered
     *         with Cognito under a different identity ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.GetOpenIdTokenForDeveloperIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetOpenIdTokenForDeveloperIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOpenIdTokenForDeveloperIdentityResponse> getOpenIdTokenForDeveloperIdentity(
            Consumer<GetOpenIdTokenForDeveloperIdentityRequest.Builder> getOpenIdTokenForDeveloperIdentityRequest) {
        return getOpenIdTokenForDeveloperIdentity(GetOpenIdTokenForDeveloperIdentityRequest.builder()
                .applyMutation(getOpenIdTokenForDeveloperIdentityRequest).build());
    }

    /**
     * <p>
     * Use <code>GetPrincipalTagAttributeMap</code> to list all mappings between <code>PrincipalTags</code> and user
     * attributes.
     * </p>
     *
     * @param getPrincipalTagAttributeMapRequest
     * @return A Java Future containing the result of the GetPrincipalTagAttributeMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.GetPrincipalTagAttributeMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetPrincipalTagAttributeMap"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPrincipalTagAttributeMapResponse> getPrincipalTagAttributeMap(
            GetPrincipalTagAttributeMapRequest getPrincipalTagAttributeMapRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use <code>GetPrincipalTagAttributeMap</code> to list all mappings between <code>PrincipalTags</code> and user
     * attributes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPrincipalTagAttributeMapRequest.Builder}
     * avoiding the need to create one manually via {@link GetPrincipalTagAttributeMapRequest#builder()}
     * </p>
     *
     * @param getPrincipalTagAttributeMapRequest
     *        A {@link Consumer} that will call methods on {@link GetPrincipalTagAttributeMapInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPrincipalTagAttributeMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.GetPrincipalTagAttributeMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetPrincipalTagAttributeMap"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPrincipalTagAttributeMapResponse> getPrincipalTagAttributeMap(
            Consumer<GetPrincipalTagAttributeMapRequest.Builder> getPrincipalTagAttributeMapRequest) {
        return getPrincipalTagAttributeMap(GetPrincipalTagAttributeMapRequest.builder()
                .applyMutation(getPrincipalTagAttributeMapRequest).build());
    }

    /**
     * <p>
     * Lists the identities in an identity pool.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     *
     * @param listIdentitiesRequest
     *        Input to the ListIdentities action.
     * @return A Java Future containing the result of the ListIdentities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.ListIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/ListIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIdentitiesResponse> listIdentities(ListIdentitiesRequest listIdentitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the identities in an identity pool.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentitiesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIdentitiesRequest#builder()}
     * </p>
     *
     * @param listIdentitiesRequest
     *        A {@link Consumer} that will call methods on {@link ListIdentitiesInput.Builder} to create a request.
     *        Input to the ListIdentities action.
     * @return A Java Future containing the result of the ListIdentities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.ListIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/ListIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIdentitiesResponse> listIdentities(Consumer<ListIdentitiesRequest.Builder> listIdentitiesRequest) {
        return listIdentities(ListIdentitiesRequest.builder().applyMutation(listIdentitiesRequest).build());
    }

    /**
     * <p>
     * Lists all of the Cognito identity pools registered for your account.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     *
     * @param listIdentityPoolsRequest
     *        Input to the ListIdentityPools action.
     * @return A Java Future containing the result of the ListIdentityPools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.ListIdentityPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/ListIdentityPools"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIdentityPoolsResponse> listIdentityPools(ListIdentityPoolsRequest listIdentityPoolsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the Cognito identity pools registered for your account.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityPoolsRequest.Builder} avoiding the need
     * to create one manually via {@link ListIdentityPoolsRequest#builder()}
     * </p>
     *
     * @param listIdentityPoolsRequest
     *        A {@link Consumer} that will call methods on {@link ListIdentityPoolsInput.Builder} to create a request.
     *        Input to the ListIdentityPools action.
     * @return A Java Future containing the result of the ListIdentityPools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.ListIdentityPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/ListIdentityPools"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIdentityPoolsResponse> listIdentityPools(
            Consumer<ListIdentityPoolsRequest.Builder> listIdentityPoolsRequest) {
        return listIdentityPools(ListIdentityPoolsRequest.builder().applyMutation(listIdentityPoolsRequest).build());
    }

    /**
     * <p>
     * Lists all of the Cognito identity pools registered for your account.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIdentityPools(software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentity.paginators.ListIdentityPoolsPublisher publisher = client.listIdentityPoolsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentity.paginators.ListIdentityPoolsPublisher publisher = client.listIdentityPoolsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentityPools(software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIdentityPoolsRequest
     *        Input to the ListIdentityPools action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.ListIdentityPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/ListIdentityPools"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityPoolsPublisher listIdentityPoolsPaginator(ListIdentityPoolsRequest listIdentityPoolsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the Cognito identity pools registered for your account.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIdentityPools(software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentity.paginators.ListIdentityPoolsPublisher publisher = client.listIdentityPoolsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentity.paginators.ListIdentityPoolsPublisher publisher = client.listIdentityPoolsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentityPools(software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityPoolsRequest.Builder} avoiding the need
     * to create one manually via {@link ListIdentityPoolsRequest#builder()}
     * </p>
     *
     * @param listIdentityPoolsRequest
     *        A {@link Consumer} that will call methods on {@link ListIdentityPoolsInput.Builder} to create a request.
     *        Input to the ListIdentityPools action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.ListIdentityPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/ListIdentityPools"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityPoolsPublisher listIdentityPoolsPaginator(
            Consumer<ListIdentityPoolsRequest.Builder> listIdentityPoolsRequest) {
        return listIdentityPoolsPaginator(ListIdentityPoolsRequest.builder().applyMutation(listIdentityPoolsRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are assigned to an Amazon Cognito identity pool.
     * </p>
     * <p>
     * A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by
     * purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * You can use this action up to 10 times per second, per account.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are assigned to an Amazon Cognito identity pool.
     * </p>
     * <p>
     * A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by
     * purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * You can use this action up to 10 times per second, per account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves the <code>IdentityID</code> associated with a <code>DeveloperUserIdentifier</code> or the list of
     * <code>DeveloperUserIdentifier</code> values associated with an <code>IdentityId</code> for an existing identity.
     * Either <code>IdentityID</code> or <code>DeveloperUserIdentifier</code> must not be null. If you supply only one
     * of these values, the other value will be searched in the database and returned as a part of the response. If you
     * supply both, <code>DeveloperUserIdentifier</code> will be matched against <code>IdentityID</code>. If the values
     * are verified against the database, the response returns both values and is the same as the request. Otherwise a
     * <code>ResourceConflictException</code> is thrown.
     * </p>
     * <p>
     * <code>LookupDeveloperIdentity</code> is intended for low-throughput control plane operations: for example, to
     * enable customer service to locate an identity ID by username. If you are using it for higher-volume operations
     * such as user authentication, your requests are likely to be throttled. <a>GetOpenIdTokenForDeveloperIdentity</a>
     * is a better option for higher-volume operations for user authentication.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     *
     * @param lookupDeveloperIdentityRequest
     *        Input to the <code>LookupDeveloperIdentityInput</code> action.
     * @return A Java Future containing the result of the LookupDeveloperIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.LookupDeveloperIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/LookupDeveloperIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<LookupDeveloperIdentityResponse> lookupDeveloperIdentity(
            LookupDeveloperIdentityRequest lookupDeveloperIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the <code>IdentityID</code> associated with a <code>DeveloperUserIdentifier</code> or the list of
     * <code>DeveloperUserIdentifier</code> values associated with an <code>IdentityId</code> for an existing identity.
     * Either <code>IdentityID</code> or <code>DeveloperUserIdentifier</code> must not be null. If you supply only one
     * of these values, the other value will be searched in the database and returned as a part of the response. If you
     * supply both, <code>DeveloperUserIdentifier</code> will be matched against <code>IdentityID</code>. If the values
     * are verified against the database, the response returns both values and is the same as the request. Otherwise a
     * <code>ResourceConflictException</code> is thrown.
     * </p>
     * <p>
     * <code>LookupDeveloperIdentity</code> is intended for low-throughput control plane operations: for example, to
     * enable customer service to locate an identity ID by username. If you are using it for higher-volume operations
     * such as user authentication, your requests are likely to be throttled. <a>GetOpenIdTokenForDeveloperIdentity</a>
     * is a better option for higher-volume operations for user authentication.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link LookupDeveloperIdentityRequest.Builder} avoiding
     * the need to create one manually via {@link LookupDeveloperIdentityRequest#builder()}
     * </p>
     *
     * @param lookupDeveloperIdentityRequest
     *        A {@link Consumer} that will call methods on {@link LookupDeveloperIdentityInput.Builder} to create a
     *        request. Input to the <code>LookupDeveloperIdentityInput</code> action.
     * @return A Java Future containing the result of the LookupDeveloperIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.LookupDeveloperIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/LookupDeveloperIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<LookupDeveloperIdentityResponse> lookupDeveloperIdentity(
            Consumer<LookupDeveloperIdentityRequest.Builder> lookupDeveloperIdentityRequest) {
        return lookupDeveloperIdentity(LookupDeveloperIdentityRequest.builder().applyMutation(lookupDeveloperIdentityRequest)
                .build());
    }

    /**
     * <p>
     * Merges two users having different <code>IdentityId</code>s, existing in the same identity pool, and identified by
     * the same developer provider. You can use this action to request that discrete users be merged and identified as a
     * single user in the Cognito environment. Cognito associates the given source user (
     * <code>SourceUserIdentifier</code>) with the <code>IdentityId</code> of the <code>DestinationUserIdentifier</code>
     * . Only developer-authenticated users can be merged. If the users to be merged are associated with the same public
     * provider, but as two different users, an exception will be thrown.
     * </p>
     * <p>
     * The number of linked logins is limited to 20. So, the number of linked logins for the source user,
     * <code>SourceUserIdentifier</code>, and the destination user, <code>DestinationUserIdentifier</code>, together
     * should not be larger than 20. Otherwise, an exception will be thrown.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     *
     * @param mergeDeveloperIdentitiesRequest
     *        Input to the <code>MergeDeveloperIdentities</code> action.
     * @return A Java Future containing the result of the MergeDeveloperIdentities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.MergeDeveloperIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/MergeDeveloperIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MergeDeveloperIdentitiesResponse> mergeDeveloperIdentities(
            MergeDeveloperIdentitiesRequest mergeDeveloperIdentitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Merges two users having different <code>IdentityId</code>s, existing in the same identity pool, and identified by
     * the same developer provider. You can use this action to request that discrete users be merged and identified as a
     * single user in the Cognito environment. Cognito associates the given source user (
     * <code>SourceUserIdentifier</code>) with the <code>IdentityId</code> of the <code>DestinationUserIdentifier</code>
     * . Only developer-authenticated users can be merged. If the users to be merged are associated with the same public
     * provider, but as two different users, an exception will be thrown.
     * </p>
     * <p>
     * The number of linked logins is limited to 20. So, the number of linked logins for the source user,
     * <code>SourceUserIdentifier</code>, and the destination user, <code>DestinationUserIdentifier</code>, together
     * should not be larger than 20. Otherwise, an exception will be thrown.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MergeDeveloperIdentitiesRequest.Builder} avoiding
     * the need to create one manually via {@link MergeDeveloperIdentitiesRequest#builder()}
     * </p>
     *
     * @param mergeDeveloperIdentitiesRequest
     *        A {@link Consumer} that will call methods on {@link MergeDeveloperIdentitiesInput.Builder} to create a
     *        request. Input to the <code>MergeDeveloperIdentities</code> action.
     * @return A Java Future containing the result of the MergeDeveloperIdentities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.MergeDeveloperIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/MergeDeveloperIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MergeDeveloperIdentitiesResponse> mergeDeveloperIdentities(
            Consumer<MergeDeveloperIdentitiesRequest.Builder> mergeDeveloperIdentitiesRequest) {
        return mergeDeveloperIdentities(MergeDeveloperIdentitiesRequest.builder().applyMutation(mergeDeveloperIdentitiesRequest)
                .build());
    }

    /**
     * <p>
     * Sets the roles for an identity pool. These roles are used when making calls to <a>GetCredentialsForIdentity</a>
     * action.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     *
     * @param setIdentityPoolRolesRequest
     *        Input to the <code>SetIdentityPoolRoles</code> action.
     * @return A Java Future containing the result of the SetIdentityPoolRoles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>ConcurrentModificationException Thrown if there are parallel requests to modify a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.SetIdentityPoolRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/SetIdentityPoolRoles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetIdentityPoolRolesResponse> setIdentityPoolRoles(
            SetIdentityPoolRolesRequest setIdentityPoolRolesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the roles for an identity pool. These roles are used when making calls to <a>GetCredentialsForIdentity</a>
     * action.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetIdentityPoolRolesRequest.Builder} avoiding the
     * need to create one manually via {@link SetIdentityPoolRolesRequest#builder()}
     * </p>
     *
     * @param setIdentityPoolRolesRequest
     *        A {@link Consumer} that will call methods on {@link SetIdentityPoolRolesInput.Builder} to create a
     *        request. Input to the <code>SetIdentityPoolRoles</code> action.
     * @return A Java Future containing the result of the SetIdentityPoolRoles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>ConcurrentModificationException Thrown if there are parallel requests to modify a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.SetIdentityPoolRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/SetIdentityPoolRoles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetIdentityPoolRolesResponse> setIdentityPoolRoles(
            Consumer<SetIdentityPoolRolesRequest.Builder> setIdentityPoolRolesRequest) {
        return setIdentityPoolRoles(SetIdentityPoolRolesRequest.builder().applyMutation(setIdentityPoolRolesRequest).build());
    }

    /**
     * <p>
     * You can use this operation to use default (username and clientID) attribute or custom attribute mappings.
     * </p>
     *
     * @param setPrincipalTagAttributeMapRequest
     * @return A Java Future containing the result of the SetPrincipalTagAttributeMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.SetPrincipalTagAttributeMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/SetPrincipalTagAttributeMap"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetPrincipalTagAttributeMapResponse> setPrincipalTagAttributeMap(
            SetPrincipalTagAttributeMapRequest setPrincipalTagAttributeMapRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You can use this operation to use default (username and clientID) attribute or custom attribute mappings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetPrincipalTagAttributeMapRequest.Builder}
     * avoiding the need to create one manually via {@link SetPrincipalTagAttributeMapRequest#builder()}
     * </p>
     *
     * @param setPrincipalTagAttributeMapRequest
     *        A {@link Consumer} that will call methods on {@link SetPrincipalTagAttributeMapInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SetPrincipalTagAttributeMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.SetPrincipalTagAttributeMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/SetPrincipalTagAttributeMap"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetPrincipalTagAttributeMapResponse> setPrincipalTagAttributeMap(
            Consumer<SetPrincipalTagAttributeMapRequest.Builder> setPrincipalTagAttributeMapRequest) {
        return setPrincipalTagAttributeMap(SetPrincipalTagAttributeMapRequest.builder()
                .applyMutation(setPrincipalTagAttributeMapRequest).build());
    }

    /**
     * <p>
     * Assigns a set of tags to the specified Amazon Cognito identity pool. A tag is a label that you can use to
     * categorize and manage identity pools in different ways, such as by purpose, owner, environment, or other
     * criteria.
     * </p>
     * <p>
     * Each tag consists of a key and value, both of which you define. A key is a general category for more specific
     * values. For example, if you have two versions of an identity pool, one for testing and another for production,
     * you might assign an <code>Environment</code> tag key to both identity pools. The value of this key might be
     * <code>Test</code> for one identity pool and <code>Production</code> for the other.
     * </p>
     * <p>
     * Tags are useful for cost tracking and access control. You can activate your tags so that they appear on the
     * Billing and Cost Management console, where you can track the costs associated with your identity pools. In an IAM
     * policy, you can constrain permissions for identity pools based on specific tags or tag values.
     * </p>
     * <p>
     * You can use this action up to 5 times per second, per account. An identity pool can have as many as 50 tags.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns a set of tags to the specified Amazon Cognito identity pool. A tag is a label that you can use to
     * categorize and manage identity pools in different ways, such as by purpose, owner, environment, or other
     * criteria.
     * </p>
     * <p>
     * Each tag consists of a key and value, both of which you define. A key is a general category for more specific
     * values. For example, if you have two versions of an identity pool, one for testing and another for production,
     * you might assign an <code>Environment</code> tag key to both identity pools. The value of this key might be
     * <code>Test</code> for one identity pool and <code>Production</code> for the other.
     * </p>
     * <p>
     * Tags are useful for cost tracking and access control. You can activate your tags so that they appear on the
     * Billing and Cost Management console, where you can track the costs associated with your identity pools. In an IAM
     * policy, you can constrain permissions for identity pools based on specific tags or tag values.
     * </p>
     * <p>
     * You can use this action up to 5 times per second, per account. An identity pool can have as many as 50 tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Unlinks a <code>DeveloperUserIdentifier</code> from an existing identity. Unlinked developer users will be
     * considered new identities next time they are seen. If, for a given Cognito identity, you remove all federated
     * identities as well as the developer user identifier, the Cognito identity becomes inaccessible.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     *
     * @param unlinkDeveloperIdentityRequest
     *        Input to the <code>UnlinkDeveloperIdentity</code> action.
     * @return A Java Future containing the result of the UnlinkDeveloperIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.UnlinkDeveloperIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/UnlinkDeveloperIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UnlinkDeveloperIdentityResponse> unlinkDeveloperIdentity(
            UnlinkDeveloperIdentityRequest unlinkDeveloperIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Unlinks a <code>DeveloperUserIdentifier</code> from an existing identity. Unlinked developer users will be
     * considered new identities next time they are seen. If, for a given Cognito identity, you remove all federated
     * identities as well as the developer user identifier, the Cognito identity becomes inaccessible.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UnlinkDeveloperIdentityRequest.Builder} avoiding
     * the need to create one manually via {@link UnlinkDeveloperIdentityRequest#builder()}
     * </p>
     *
     * @param unlinkDeveloperIdentityRequest
     *        A {@link Consumer} that will call methods on {@link UnlinkDeveloperIdentityInput.Builder} to create a
     *        request. Input to the <code>UnlinkDeveloperIdentity</code> action.
     * @return A Java Future containing the result of the UnlinkDeveloperIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.UnlinkDeveloperIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/UnlinkDeveloperIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UnlinkDeveloperIdentityResponse> unlinkDeveloperIdentity(
            Consumer<UnlinkDeveloperIdentityRequest.Builder> unlinkDeveloperIdentityRequest) {
        return unlinkDeveloperIdentity(UnlinkDeveloperIdentityRequest.builder().applyMutation(unlinkDeveloperIdentityRequest)
                .build());
    }

    /**
     * <p>
     * Unlinks a federated identity from an existing account. Unlinked logins will be considered new identities next
     * time they are seen. Removing the last linked login will make this identity inaccessible.
     * </p>
     * <p>
     * This is a public API. You do not need any credentials to call this API.
     * </p>
     *
     * @param unlinkIdentityRequest
     *        Input to the UnlinkIdentity action.
     * @return A Java Future containing the result of the UnlinkIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>ExternalServiceException An exception thrown when a dependent service such as Facebook or Twitter is
     *         not responding</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.UnlinkIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/UnlinkIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UnlinkIdentityResponse> unlinkIdentity(UnlinkIdentityRequest unlinkIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Unlinks a federated identity from an existing account. Unlinked logins will be considered new identities next
     * time they are seen. Removing the last linked login will make this identity inaccessible.
     * </p>
     * <p>
     * This is a public API. You do not need any credentials to call this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UnlinkIdentityRequest.Builder} avoiding the need to
     * create one manually via {@link UnlinkIdentityRequest#builder()}
     * </p>
     *
     * @param unlinkIdentityRequest
     *        A {@link Consumer} that will call methods on {@link UnlinkIdentityInput.Builder} to create a request.
     *        Input to the UnlinkIdentity action.
     * @return A Java Future containing the result of the UnlinkIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>ExternalServiceException An exception thrown when a dependent service such as Facebook or Twitter is
     *         not responding</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.UnlinkIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/UnlinkIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UnlinkIdentityResponse> unlinkIdentity(Consumer<UnlinkIdentityRequest.Builder> unlinkIdentityRequest) {
        return unlinkIdentity(UnlinkIdentityRequest.builder().applyMutation(unlinkIdentityRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified Amazon Cognito identity pool. You can use this action up to 5 times
     * per second, per account
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified Amazon Cognito identity pool. You can use this action up to 5 times
     * per second, per account
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an identity pool.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     *
     * @param updateIdentityPoolRequest
     *        An object representing an Amazon Cognito identity pool.
     * @return A Java Future containing the result of the UpdateIdentityPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>ConcurrentModificationException Thrown if there are parallel requests to modify a resource.</li>
     *         <li>LimitExceededException Thrown when the total number of user pools has exceeded a preset limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.UpdateIdentityPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/UpdateIdentityPool"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIdentityPoolResponse> updateIdentityPool(UpdateIdentityPoolRequest updateIdentityPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an identity pool.
     * </p>
     * <p>
     * You must use AWS Developer credentials to call this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIdentityPoolRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateIdentityPoolRequest#builder()}
     * </p>
     *
     * @param updateIdentityPoolRequest
     *        A {@link Consumer} that will call methods on {@link IdentityPool.Builder} to create a request. An object
     *        representing an Amazon Cognito identity pool.
     * @return A Java Future containing the result of the UpdateIdentityPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Thrown for missing or bad input parameter(s).</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource (for example, a dataset or record) does
     *         not exist.</li>
     *         <li>NotAuthorizedException Thrown when a user is not authorized to access the requested resource.</li>
     *         <li>ResourceConflictException Thrown when a user tries to use a login which is already linked to another
     *         account.</li>
     *         <li>TooManyRequestsException Thrown when a request is throttled.</li>
     *         <li>InternalErrorException Thrown when the service encounters an error during processing the request.</li>
     *         <li>ConcurrentModificationException Thrown if there are parallel requests to modify a resource.</li>
     *         <li>LimitExceededException Thrown when the total number of user pools has exceeded a preset limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityAsyncClient.UpdateIdentityPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/UpdateIdentityPool"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIdentityPoolResponse> updateIdentityPool(
            Consumer<UpdateIdentityPoolRequest.Builder> updateIdentityPoolRequest) {
        return updateIdentityPool(UpdateIdentityPoolRequest.builder().applyMutation(updateIdentityPoolRequest).build());
    }
}
