/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetPrincipalTagAttributeMapRequest extends CognitoIdentityRequest implements
        ToCopyableBuilder<SetPrincipalTagAttributeMapRequest.Builder, SetPrincipalTagAttributeMapRequest> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityPoolId").getter(getter(SetPrincipalTagAttributeMapRequest::identityPoolId))
            .setter(setter(Builder::identityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()).build();

    private static final SdkField<String> IDENTITY_PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityProviderName").getter(getter(SetPrincipalTagAttributeMapRequest::identityProviderName))
            .setter(setter(Builder::identityProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderName").build())
            .build();

    private static final SdkField<Boolean> USE_DEFAULTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseDefaults").getter(getter(SetPrincipalTagAttributeMapRequest::useDefaults))
            .setter(setter(Builder::useDefaults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseDefaults").build()).build();

    private static final SdkField<Map<String, String>> PRINCIPAL_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("PrincipalTags")
            .getter(getter(SetPrincipalTagAttributeMapRequest::principalTags))
            .setter(setter(Builder::principalTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD,
            IDENTITY_PROVIDER_NAME_FIELD, USE_DEFAULTS_FIELD, PRINCIPAL_TAGS_FIELD));

    private final String identityPoolId;

    private final String identityProviderName;

    private final Boolean useDefaults;

    private final Map<String, String> principalTags;

    private SetPrincipalTagAttributeMapRequest(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identityProviderName = builder.identityProviderName;
        this.useDefaults = builder.useDefaults;
        this.principalTags = builder.principalTags;
    }

    /**
     * <p>
     * The ID of the Identity Pool you want to set attribute mappings for.
     * </p>
     * 
     * @return The ID of the Identity Pool you want to set attribute mappings for.
     */
    public final String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * The provider name you want to use for attribute mappings.
     * </p>
     * 
     * @return The provider name you want to use for attribute mappings.
     */
    public final String identityProviderName() {
        return identityProviderName;
    }

    /**
     * <p>
     * You can use this operation to use default (username and clientID) attribute mappings.
     * </p>
     * 
     * @return You can use this operation to use default (username and clientID) attribute mappings.
     */
    public final Boolean useDefaults() {
        return useDefaults;
    }

    /**
     * Returns true if the PrincipalTags property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPrincipalTags() {
        return principalTags != null && !(principalTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * You can use this operation to add principal tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPrincipalTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return You can use this operation to add principal tags.
     */
    public final Map<String, String> principalTags() {
        return principalTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(useDefaults());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrincipalTags() ? principalTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetPrincipalTagAttributeMapRequest)) {
            return false;
        }
        SetPrincipalTagAttributeMapRequest other = (SetPrincipalTagAttributeMapRequest) obj;
        return Objects.equals(identityPoolId(), other.identityPoolId())
                && Objects.equals(identityProviderName(), other.identityProviderName())
                && Objects.equals(useDefaults(), other.useDefaults()) && hasPrincipalTags() == other.hasPrincipalTags()
                && Objects.equals(principalTags(), other.principalTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetPrincipalTagAttributeMapRequest").add("IdentityPoolId", identityPoolId())
                .add("IdentityProviderName", identityProviderName()).add("UseDefaults", useDefaults())
                .add("PrincipalTags", hasPrincipalTags() ? principalTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPoolId":
            return Optional.ofNullable(clazz.cast(identityPoolId()));
        case "IdentityProviderName":
            return Optional.ofNullable(clazz.cast(identityProviderName()));
        case "UseDefaults":
            return Optional.ofNullable(clazz.cast(useDefaults()));
        case "PrincipalTags":
            return Optional.ofNullable(clazz.cast(principalTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetPrincipalTagAttributeMapRequest, T> g) {
        return obj -> g.apply((SetPrincipalTagAttributeMapRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SetPrincipalTagAttributeMapRequest> {
        /**
         * <p>
         * The ID of the Identity Pool you want to set attribute mappings for.
         * </p>
         * 
         * @param identityPoolId
         *        The ID of the Identity Pool you want to set attribute mappings for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * The provider name you want to use for attribute mappings.
         * </p>
         * 
         * @param identityProviderName
         *        The provider name you want to use for attribute mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderName(String identityProviderName);

        /**
         * <p>
         * You can use this operation to use default (username and clientID) attribute mappings.
         * </p>
         * 
         * @param useDefaults
         *        You can use this operation to use default (username and clientID) attribute mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useDefaults(Boolean useDefaults);

        /**
         * <p>
         * You can use this operation to add principal tags.
         * </p>
         * 
         * @param principalTags
         *        You can use this operation to add principal tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalTags(Map<String, String> principalTags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityRequest.BuilderImpl implements Builder {
        private String identityPoolId;

        private String identityProviderName;

        private Boolean useDefaults;

        private Map<String, String> principalTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SetPrincipalTagAttributeMapRequest model) {
            super(model);
            identityPoolId(model.identityPoolId);
            identityProviderName(model.identityProviderName);
            useDefaults(model.useDefaults);
            principalTags(model.principalTags);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        @Transient
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final String getIdentityProviderName() {
            return identityProviderName;
        }

        public final void setIdentityProviderName(String identityProviderName) {
            this.identityProviderName = identityProviderName;
        }

        @Override
        @Transient
        public final Builder identityProviderName(String identityProviderName) {
            this.identityProviderName = identityProviderName;
            return this;
        }

        public final Boolean getUseDefaults() {
            return useDefaults;
        }

        public final void setUseDefaults(Boolean useDefaults) {
            this.useDefaults = useDefaults;
        }

        @Override
        @Transient
        public final Builder useDefaults(Boolean useDefaults) {
            this.useDefaults = useDefaults;
            return this;
        }

        public final Map<String, String> getPrincipalTags() {
            if (principalTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return principalTags;
        }

        public final void setPrincipalTags(Map<String, String> principalTags) {
            this.principalTags = PrincipalTagsCopier.copy(principalTags);
        }

        @Override
        @Transient
        public final Builder principalTags(Map<String, String> principalTags) {
            this.principalTags = PrincipalTagsCopier.copy(principalTags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetPrincipalTagAttributeMapRequest build() {
            return new SetPrincipalTagAttributeMapRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
