/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MergeDeveloperIdentitiesRequest
extends CognitoIdentityRequest
implements ToCopyableBuilder<Builder, MergeDeveloperIdentitiesRequest> {
    private static final SdkField<String> SOURCE_USER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceUserIdentifier").getter(MergeDeveloperIdentitiesRequest.getter(MergeDeveloperIdentitiesRequest::sourceUserIdentifier)).setter(MergeDeveloperIdentitiesRequest.setter(Builder::sourceUserIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUserIdentifier").build()}).build();
    private static final SdkField<String> DESTINATION_USER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationUserIdentifier").getter(MergeDeveloperIdentitiesRequest.getter(MergeDeveloperIdentitiesRequest::destinationUserIdentifier)).setter(MergeDeveloperIdentitiesRequest.setter(Builder::destinationUserIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationUserIdentifier").build()}).build();
    private static final SdkField<String> DEVELOPER_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeveloperProviderName").getter(MergeDeveloperIdentitiesRequest.getter(MergeDeveloperIdentitiesRequest::developerProviderName)).setter(MergeDeveloperIdentitiesRequest.setter(Builder::developerProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeveloperProviderName").build()}).build();
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityPoolId").getter(MergeDeveloperIdentitiesRequest.getter(MergeDeveloperIdentitiesRequest::identityPoolId)).setter(MergeDeveloperIdentitiesRequest.setter(Builder::identityPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_USER_IDENTIFIER_FIELD, DESTINATION_USER_IDENTIFIER_FIELD, DEVELOPER_PROVIDER_NAME_FIELD, IDENTITY_POOL_ID_FIELD));
    private final String sourceUserIdentifier;
    private final String destinationUserIdentifier;
    private final String developerProviderName;
    private final String identityPoolId;

    private MergeDeveloperIdentitiesRequest(BuilderImpl builder) {
        super(builder);
        this.sourceUserIdentifier = builder.sourceUserIdentifier;
        this.destinationUserIdentifier = builder.destinationUserIdentifier;
        this.developerProviderName = builder.developerProviderName;
        this.identityPoolId = builder.identityPoolId;
    }

    public final String sourceUserIdentifier() {
        return this.sourceUserIdentifier;
    }

    public final String destinationUserIdentifier() {
        return this.destinationUserIdentifier;
    }

    public final String developerProviderName() {
        return this.developerProviderName;
    }

    public final String identityPoolId() {
        return this.identityPoolId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceUserIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationUserIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.developerProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeDeveloperIdentitiesRequest)) {
            return false;
        }
        MergeDeveloperIdentitiesRequest other = (MergeDeveloperIdentitiesRequest)((Object)obj);
        return Objects.equals(this.sourceUserIdentifier(), other.sourceUserIdentifier()) && Objects.equals(this.destinationUserIdentifier(), other.destinationUserIdentifier()) && Objects.equals(this.developerProviderName(), other.developerProviderName()) && Objects.equals(this.identityPoolId(), other.identityPoolId());
    }

    public final String toString() {
        return ToString.builder((String)"MergeDeveloperIdentitiesRequest").add("SourceUserIdentifier", (Object)this.sourceUserIdentifier()).add("DestinationUserIdentifier", (Object)this.destinationUserIdentifier()).add("DeveloperProviderName", (Object)this.developerProviderName()).add("IdentityPoolId", (Object)this.identityPoolId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceUserIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceUserIdentifier()));
            }
            case "DestinationUserIdentifier": {
                return Optional.ofNullable(clazz.cast(this.destinationUserIdentifier()));
            }
            case "DeveloperProviderName": {
                return Optional.ofNullable(clazz.cast(this.developerProviderName()));
            }
            case "IdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.identityPoolId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MergeDeveloperIdentitiesRequest, T> g) {
        return obj -> g.apply((MergeDeveloperIdentitiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityRequest.BuilderImpl
    implements Builder {
        private String sourceUserIdentifier;
        private String destinationUserIdentifier;
        private String developerProviderName;
        private String identityPoolId;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeDeveloperIdentitiesRequest model) {
            super(model);
            this.sourceUserIdentifier(model.sourceUserIdentifier);
            this.destinationUserIdentifier(model.destinationUserIdentifier);
            this.developerProviderName(model.developerProviderName);
            this.identityPoolId(model.identityPoolId);
        }

        public final String getSourceUserIdentifier() {
            return this.sourceUserIdentifier;
        }

        public final void setSourceUserIdentifier(String sourceUserIdentifier) {
            this.sourceUserIdentifier = sourceUserIdentifier;
        }

        @Override
        @Transient
        public final Builder sourceUserIdentifier(String sourceUserIdentifier) {
            this.sourceUserIdentifier = sourceUserIdentifier;
            return this;
        }

        public final String getDestinationUserIdentifier() {
            return this.destinationUserIdentifier;
        }

        public final void setDestinationUserIdentifier(String destinationUserIdentifier) {
            this.destinationUserIdentifier = destinationUserIdentifier;
        }

        @Override
        @Transient
        public final Builder destinationUserIdentifier(String destinationUserIdentifier) {
            this.destinationUserIdentifier = destinationUserIdentifier;
            return this;
        }

        public final String getDeveloperProviderName() {
            return this.developerProviderName;
        }

        public final void setDeveloperProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
        }

        @Override
        @Transient
        public final Builder developerProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
            return this;
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        @Transient
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MergeDeveloperIdentitiesRequest build() {
            return new MergeDeveloperIdentitiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, MergeDeveloperIdentitiesRequest> {
        public Builder sourceUserIdentifier(String var1);

        public Builder destinationUserIdentifier(String var1);

        public Builder developerProviderName(String var1);

        public Builder identityPoolId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

