/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing an Amazon Cognito identity pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIdentityPoolResponse extends CognitoIdentityResponse implements
        ToCopyableBuilder<UpdateIdentityPoolResponse.Builder, UpdateIdentityPoolResponse> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityPoolId").getter(getter(UpdateIdentityPoolResponse::identityPoolId))
            .setter(setter(Builder::identityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()).build();

    private static final SdkField<String> IDENTITY_POOL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityPoolName").getter(getter(UpdateIdentityPoolResponse::identityPoolName))
            .setter(setter(Builder::identityPoolName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolName").build()).build();

    private static final SdkField<Boolean> ALLOW_UNAUTHENTICATED_IDENTITIES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowUnauthenticatedIdentities")
            .getter(getter(UpdateIdentityPoolResponse::allowUnauthenticatedIdentities))
            .setter(setter(Builder::allowUnauthenticatedIdentities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowUnauthenticatedIdentities")
                    .build()).build();

    private static final SdkField<Boolean> ALLOW_CLASSIC_FLOW_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowClassicFlow").getter(getter(UpdateIdentityPoolResponse::allowClassicFlow))
            .setter(setter(Builder::allowClassicFlow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowClassicFlow").build()).build();

    private static final SdkField<Map<String, String>> SUPPORTED_LOGIN_PROVIDERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("SupportedLoginProviders")
            .getter(getter(UpdateIdentityPoolResponse::supportedLoginProviders))
            .setter(setter(Builder::supportedLoginProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedLoginProviders").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DEVELOPER_PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeveloperProviderName").getter(getter(UpdateIdentityPoolResponse::developerProviderName))
            .setter(setter(Builder::developerProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeveloperProviderName").build())
            .build();

    private static final SdkField<List<String>> OPEN_ID_CONNECT_PROVIDER_AR_NS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OpenIdConnectProviderARNs")
            .getter(getter(UpdateIdentityPoolResponse::openIdConnectProviderARNs))
            .setter(setter(Builder::openIdConnectProviderARNs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenIdConnectProviderARNs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CognitoIdentityProvider>> COGNITO_IDENTITY_PROVIDERS_FIELD = SdkField
            .<List<CognitoIdentityProvider>> builder(MarshallingType.LIST)
            .memberName("CognitoIdentityProviders")
            .getter(getter(UpdateIdentityPoolResponse::cognitoIdentityProviders))
            .setter(setter(Builder::cognitoIdentityProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoIdentityProviders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CognitoIdentityProvider> builder(MarshallingType.SDK_POJO)
                                            .constructor(CognitoIdentityProvider::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SAML_PROVIDER_AR_NS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SamlProviderARNs")
            .getter(getter(UpdateIdentityPoolResponse::samlProviderARNs))
            .setter(setter(Builder::samlProviderARNs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamlProviderARNs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> IDENTITY_POOL_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("IdentityPoolTags")
            .getter(getter(UpdateIdentityPoolResponse::identityPoolTags))
            .setter(setter(Builder::identityPoolTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD,
            IDENTITY_POOL_NAME_FIELD, ALLOW_UNAUTHENTICATED_IDENTITIES_FIELD, ALLOW_CLASSIC_FLOW_FIELD,
            SUPPORTED_LOGIN_PROVIDERS_FIELD, DEVELOPER_PROVIDER_NAME_FIELD, OPEN_ID_CONNECT_PROVIDER_AR_NS_FIELD,
            COGNITO_IDENTITY_PROVIDERS_FIELD, SAML_PROVIDER_AR_NS_FIELD, IDENTITY_POOL_TAGS_FIELD));

    private final String identityPoolId;

    private final String identityPoolName;

    private final Boolean allowUnauthenticatedIdentities;

    private final Boolean allowClassicFlow;

    private final Map<String, String> supportedLoginProviders;

    private final String developerProviderName;

    private final List<String> openIdConnectProviderARNs;

    private final List<CognitoIdentityProvider> cognitoIdentityProviders;

    private final List<String> samlProviderARNs;

    private final Map<String, String> identityPoolTags;

    private UpdateIdentityPoolResponse(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identityPoolName = builder.identityPoolName;
        this.allowUnauthenticatedIdentities = builder.allowUnauthenticatedIdentities;
        this.allowClassicFlow = builder.allowClassicFlow;
        this.supportedLoginProviders = builder.supportedLoginProviders;
        this.developerProviderName = builder.developerProviderName;
        this.openIdConnectProviderARNs = builder.openIdConnectProviderARNs;
        this.cognitoIdentityProviders = builder.cognitoIdentityProviders;
        this.samlProviderARNs = builder.samlProviderARNs;
        this.identityPoolTags = builder.identityPoolTags;
    }

    /**
     * <p>
     * An identity pool ID in the format REGION:GUID.
     * </p>
     * 
     * @return An identity pool ID in the format REGION:GUID.
     */
    public final String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * A string that you provide.
     * </p>
     * 
     * @return A string that you provide.
     */
    public final String identityPoolName() {
        return identityPoolName;
    }

    /**
     * <p>
     * TRUE if the identity pool supports unauthenticated logins.
     * </p>
     * 
     * @return TRUE if the identity pool supports unauthenticated logins.
     */
    public final Boolean allowUnauthenticatedIdentities() {
        return allowUnauthenticatedIdentities;
    }

    /**
     * <p>
     * Enables or disables the Basic (Classic) authentication flow. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools
     * (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * 
     * @return Enables or disables the Basic (Classic) authentication flow. For more information, see <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools
     *         (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.
     */
    public final Boolean allowClassicFlow() {
        return allowClassicFlow;
    }

    /**
     * Returns true if the SupportedLoginProviders property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSupportedLoginProviders() {
        return supportedLoginProviders != null && !(supportedLoginProviders instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Optional key:value pairs mapping provider names to provider app IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedLoginProviders()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Optional key:value pairs mapping provider names to provider app IDs.
     */
    public final Map<String, String> supportedLoginProviders() {
        return supportedLoginProviders;
    }

    /**
     * <p>
     * The "domain" by which Cognito will refer to your users.
     * </p>
     * 
     * @return The "domain" by which Cognito will refer to your users.
     */
    public final String developerProviderName() {
        return developerProviderName;
    }

    /**
     * Returns true if the OpenIdConnectProviderARNs property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasOpenIdConnectProviderARNs() {
        return openIdConnectProviderARNs != null && !(openIdConnectProviderARNs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of the OpenID Connect providers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOpenIdConnectProviderARNs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ARNs of the OpenID Connect providers.
     */
    public final List<String> openIdConnectProviderARNs() {
        return openIdConnectProviderARNs;
    }

    /**
     * Returns true if the CognitoIdentityProviders property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCognitoIdentityProviders() {
        return cognitoIdentityProviders != null && !(cognitoIdentityProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list representing an Amazon Cognito user pool and its client ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCognitoIdentityProviders()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list representing an Amazon Cognito user pool and its client ID.
     */
    public final List<CognitoIdentityProvider> cognitoIdentityProviders() {
        return cognitoIdentityProviders;
    }

    /**
     * Returns true if the SamlProviderARNs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSamlProviderARNs() {
        return samlProviderARNs != null && !(samlProviderARNs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSamlProviderARNs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.
     */
    public final List<String> samlProviderARNs() {
        return samlProviderARNs;
    }

    /**
     * Returns true if the IdentityPoolTags property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasIdentityPoolTags() {
        return identityPoolTags != null && !(identityPoolTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that are assigned to the identity pool. A tag is a label that you can apply to identity pools to
     * categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIdentityPoolTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags that are assigned to the identity pool. A tag is a label that you can apply to identity pools to
     *         categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.
     */
    public final Map<String, String> identityPoolTags() {
        return identityPoolTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolName());
        hashCode = 31 * hashCode + Objects.hashCode(allowUnauthenticatedIdentities());
        hashCode = 31 * hashCode + Objects.hashCode(allowClassicFlow());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedLoginProviders() ? supportedLoginProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(developerProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(hasOpenIdConnectProviderARNs() ? openIdConnectProviderARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCognitoIdentityProviders() ? cognitoIdentityProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSamlProviderARNs() ? samlProviderARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentityPoolTags() ? identityPoolTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIdentityPoolResponse)) {
            return false;
        }
        UpdateIdentityPoolResponse other = (UpdateIdentityPoolResponse) obj;
        return Objects.equals(identityPoolId(), other.identityPoolId())
                && Objects.equals(identityPoolName(), other.identityPoolName())
                && Objects.equals(allowUnauthenticatedIdentities(), other.allowUnauthenticatedIdentities())
                && Objects.equals(allowClassicFlow(), other.allowClassicFlow())
                && hasSupportedLoginProviders() == other.hasSupportedLoginProviders()
                && Objects.equals(supportedLoginProviders(), other.supportedLoginProviders())
                && Objects.equals(developerProviderName(), other.developerProviderName())
                && hasOpenIdConnectProviderARNs() == other.hasOpenIdConnectProviderARNs()
                && Objects.equals(openIdConnectProviderARNs(), other.openIdConnectProviderARNs())
                && hasCognitoIdentityProviders() == other.hasCognitoIdentityProviders()
                && Objects.equals(cognitoIdentityProviders(), other.cognitoIdentityProviders())
                && hasSamlProviderARNs() == other.hasSamlProviderARNs()
                && Objects.equals(samlProviderARNs(), other.samlProviderARNs())
                && hasIdentityPoolTags() == other.hasIdentityPoolTags()
                && Objects.equals(identityPoolTags(), other.identityPoolTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIdentityPoolResponse").add("IdentityPoolId", identityPoolId())
                .add("IdentityPoolName", identityPoolName())
                .add("AllowUnauthenticatedIdentities", allowUnauthenticatedIdentities())
                .add("AllowClassicFlow", allowClassicFlow())
                .add("SupportedLoginProviders", hasSupportedLoginProviders() ? supportedLoginProviders() : null)
                .add("DeveloperProviderName", developerProviderName())
                .add("OpenIdConnectProviderARNs", hasOpenIdConnectProviderARNs() ? openIdConnectProviderARNs() : null)
                .add("CognitoIdentityProviders", hasCognitoIdentityProviders() ? cognitoIdentityProviders() : null)
                .add("SamlProviderARNs", hasSamlProviderARNs() ? samlProviderARNs() : null)
                .add("IdentityPoolTags", hasIdentityPoolTags() ? identityPoolTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPoolId":
            return Optional.ofNullable(clazz.cast(identityPoolId()));
        case "IdentityPoolName":
            return Optional.ofNullable(clazz.cast(identityPoolName()));
        case "AllowUnauthenticatedIdentities":
            return Optional.ofNullable(clazz.cast(allowUnauthenticatedIdentities()));
        case "AllowClassicFlow":
            return Optional.ofNullable(clazz.cast(allowClassicFlow()));
        case "SupportedLoginProviders":
            return Optional.ofNullable(clazz.cast(supportedLoginProviders()));
        case "DeveloperProviderName":
            return Optional.ofNullable(clazz.cast(developerProviderName()));
        case "OpenIdConnectProviderARNs":
            return Optional.ofNullable(clazz.cast(openIdConnectProviderARNs()));
        case "CognitoIdentityProviders":
            return Optional.ofNullable(clazz.cast(cognitoIdentityProviders()));
        case "SamlProviderARNs":
            return Optional.ofNullable(clazz.cast(samlProviderARNs()));
        case "IdentityPoolTags":
            return Optional.ofNullable(clazz.cast(identityPoolTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIdentityPoolResponse, T> g) {
        return obj -> g.apply((UpdateIdentityPoolResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateIdentityPoolResponse> {
        /**
         * <p>
         * An identity pool ID in the format REGION:GUID.
         * </p>
         * 
         * @param identityPoolId
         *        An identity pool ID in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * A string that you provide.
         * </p>
         * 
         * @param identityPoolName
         *        A string that you provide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolName(String identityPoolName);

        /**
         * <p>
         * TRUE if the identity pool supports unauthenticated logins.
         * </p>
         * 
         * @param allowUnauthenticatedIdentities
         *        TRUE if the identity pool supports unauthenticated logins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities);

        /**
         * <p>
         * Enables or disables the Basic (Classic) authentication flow. For more information, see <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools
         * (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.
         * </p>
         * 
         * @param allowClassicFlow
         *        Enables or disables the Basic (Classic) authentication flow. For more information, see <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity
         *        Pools (Federated Identities) Authentication Flow</a> in the <i>Amazon Cognito Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowClassicFlow(Boolean allowClassicFlow);

        /**
         * <p>
         * Optional key:value pairs mapping provider names to provider app IDs.
         * </p>
         * 
         * @param supportedLoginProviders
         *        Optional key:value pairs mapping provider names to provider app IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedLoginProviders(Map<String, String> supportedLoginProviders);

        /**
         * <p>
         * The "domain" by which Cognito will refer to your users.
         * </p>
         * 
         * @param developerProviderName
         *        The "domain" by which Cognito will refer to your users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder developerProviderName(String developerProviderName);

        /**
         * <p>
         * The ARNs of the OpenID Connect providers.
         * </p>
         * 
         * @param openIdConnectProviderARNs
         *        The ARNs of the OpenID Connect providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIdConnectProviderARNs(Collection<String> openIdConnectProviderARNs);

        /**
         * <p>
         * The ARNs of the OpenID Connect providers.
         * </p>
         * 
         * @param openIdConnectProviderARNs
         *        The ARNs of the OpenID Connect providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIdConnectProviderARNs(String... openIdConnectProviderARNs);

        /**
         * <p>
         * A list representing an Amazon Cognito user pool and its client ID.
         * </p>
         * 
         * @param cognitoIdentityProviders
         *        A list representing an Amazon Cognito user pool and its client ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoIdentityProviders(Collection<CognitoIdentityProvider> cognitoIdentityProviders);

        /**
         * <p>
         * A list representing an Amazon Cognito user pool and its client ID.
         * </p>
         * 
         * @param cognitoIdentityProviders
         *        A list representing an Amazon Cognito user pool and its client ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoIdentityProviders(CognitoIdentityProvider... cognitoIdentityProviders);

        /**
         * <p>
         * A list representing an Amazon Cognito user pool and its client ID.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CognitoIdentityProvider>.Builder} avoiding
         * the need to create one manually via {@link List<CognitoIdentityProvider>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CognitoIdentityProvider>.Builder#build()} is called
         * immediately and its result is passed to {@link #cognitoIdentityProviders(List<CognitoIdentityProvider>)}.
         * 
         * @param cognitoIdentityProviders
         *        a consumer that will call methods on {@link List<CognitoIdentityProvider>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cognitoIdentityProviders(List<CognitoIdentityProvider>)
         */
        Builder cognitoIdentityProviders(Consumer<CognitoIdentityProvider.Builder>... cognitoIdentityProviders);

        /**
         * <p>
         * An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.
         * </p>
         * 
         * @param samlProviderARNs
         *        An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlProviderARNs(Collection<String> samlProviderARNs);

        /**
         * <p>
         * An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.
         * </p>
         * 
         * @param samlProviderARNs
         *        An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlProviderARNs(String... samlProviderARNs);

        /**
         * <p>
         * The tags that are assigned to the identity pool. A tag is a label that you can apply to identity pools to
         * categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.
         * </p>
         * 
         * @param identityPoolTags
         *        The tags that are assigned to the identity pool. A tag is a label that you can apply to identity pools
         *        to categorize and manage them in different ways, such as by purpose, owner, environment, or other
         *        criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolTags(Map<String, String> identityPoolTags);
    }

    static final class BuilderImpl extends CognitoIdentityResponse.BuilderImpl implements Builder {
        private String identityPoolId;

        private String identityPoolName;

        private Boolean allowUnauthenticatedIdentities;

        private Boolean allowClassicFlow;

        private Map<String, String> supportedLoginProviders = DefaultSdkAutoConstructMap.getInstance();

        private String developerProviderName;

        private List<String> openIdConnectProviderARNs = DefaultSdkAutoConstructList.getInstance();

        private List<CognitoIdentityProvider> cognitoIdentityProviders = DefaultSdkAutoConstructList.getInstance();

        private List<String> samlProviderARNs = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> identityPoolTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIdentityPoolResponse model) {
            super(model);
            identityPoolId(model.identityPoolId);
            identityPoolName(model.identityPoolName);
            allowUnauthenticatedIdentities(model.allowUnauthenticatedIdentities);
            allowClassicFlow(model.allowClassicFlow);
            supportedLoginProviders(model.supportedLoginProviders);
            developerProviderName(model.developerProviderName);
            openIdConnectProviderARNs(model.openIdConnectProviderARNs);
            cognitoIdentityProviders(model.cognitoIdentityProviders);
            samlProviderARNs(model.samlProviderARNs);
            identityPoolTags(model.identityPoolTags);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        @Transient
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final String getIdentityPoolName() {
            return identityPoolName;
        }

        public final void setIdentityPoolName(String identityPoolName) {
            this.identityPoolName = identityPoolName;
        }

        @Override
        @Transient
        public final Builder identityPoolName(String identityPoolName) {
            this.identityPoolName = identityPoolName;
            return this;
        }

        public final Boolean getAllowUnauthenticatedIdentities() {
            return allowUnauthenticatedIdentities;
        }

        public final void setAllowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
            this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities;
        }

        @Override
        @Transient
        public final Builder allowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
            this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities;
            return this;
        }

        public final Boolean getAllowClassicFlow() {
            return allowClassicFlow;
        }

        public final void setAllowClassicFlow(Boolean allowClassicFlow) {
            this.allowClassicFlow = allowClassicFlow;
        }

        @Override
        @Transient
        public final Builder allowClassicFlow(Boolean allowClassicFlow) {
            this.allowClassicFlow = allowClassicFlow;
            return this;
        }

        public final Map<String, String> getSupportedLoginProviders() {
            if (supportedLoginProviders instanceof SdkAutoConstructMap) {
                return null;
            }
            return supportedLoginProviders;
        }

        public final void setSupportedLoginProviders(Map<String, String> supportedLoginProviders) {
            this.supportedLoginProviders = IdentityProvidersCopier.copy(supportedLoginProviders);
        }

        @Override
        @Transient
        public final Builder supportedLoginProviders(Map<String, String> supportedLoginProviders) {
            this.supportedLoginProviders = IdentityProvidersCopier.copy(supportedLoginProviders);
            return this;
        }

        public final String getDeveloperProviderName() {
            return developerProviderName;
        }

        public final void setDeveloperProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
        }

        @Override
        @Transient
        public final Builder developerProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
            return this;
        }

        public final Collection<String> getOpenIdConnectProviderARNs() {
            if (openIdConnectProviderARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return openIdConnectProviderARNs;
        }

        public final void setOpenIdConnectProviderARNs(Collection<String> openIdConnectProviderARNs) {
            this.openIdConnectProviderARNs = OIDCProviderListCopier.copy(openIdConnectProviderARNs);
        }

        @Override
        @Transient
        public final Builder openIdConnectProviderARNs(Collection<String> openIdConnectProviderARNs) {
            this.openIdConnectProviderARNs = OIDCProviderListCopier.copy(openIdConnectProviderARNs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder openIdConnectProviderARNs(String... openIdConnectProviderARNs) {
            openIdConnectProviderARNs(Arrays.asList(openIdConnectProviderARNs));
            return this;
        }

        public final List<CognitoIdentityProvider.Builder> getCognitoIdentityProviders() {
            List<CognitoIdentityProvider.Builder> result = CognitoIdentityProviderListCopier
                    .copyToBuilder(this.cognitoIdentityProviders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCognitoIdentityProviders(Collection<CognitoIdentityProvider.BuilderImpl> cognitoIdentityProviders) {
            this.cognitoIdentityProviders = CognitoIdentityProviderListCopier.copyFromBuilder(cognitoIdentityProviders);
        }

        @Override
        @Transient
        public final Builder cognitoIdentityProviders(Collection<CognitoIdentityProvider> cognitoIdentityProviders) {
            this.cognitoIdentityProviders = CognitoIdentityProviderListCopier.copy(cognitoIdentityProviders);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cognitoIdentityProviders(CognitoIdentityProvider... cognitoIdentityProviders) {
            cognitoIdentityProviders(Arrays.asList(cognitoIdentityProviders));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cognitoIdentityProviders(Consumer<CognitoIdentityProvider.Builder>... cognitoIdentityProviders) {
            cognitoIdentityProviders(Stream.of(cognitoIdentityProviders)
                    .map(c -> CognitoIdentityProvider.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSamlProviderARNs() {
            if (samlProviderARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return samlProviderARNs;
        }

        public final void setSamlProviderARNs(Collection<String> samlProviderARNs) {
            this.samlProviderARNs = SAMLProviderListCopier.copy(samlProviderARNs);
        }

        @Override
        @Transient
        public final Builder samlProviderARNs(Collection<String> samlProviderARNs) {
            this.samlProviderARNs = SAMLProviderListCopier.copy(samlProviderARNs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder samlProviderARNs(String... samlProviderARNs) {
            samlProviderARNs(Arrays.asList(samlProviderARNs));
            return this;
        }

        public final Map<String, String> getIdentityPoolTags() {
            if (identityPoolTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return identityPoolTags;
        }

        public final void setIdentityPoolTags(Map<String, String> identityPoolTags) {
            this.identityPoolTags = IdentityPoolTagsTypeCopier.copy(identityPoolTags);
        }

        @Override
        @Transient
        public final Builder identityPoolTags(Map<String, String> identityPoolTags) {
            this.identityPoolTags = IdentityPoolTagsTypeCopier.copy(identityPoolTags);
            return this;
        }

        @Override
        public UpdateIdentityPoolResponse build() {
            return new UpdateIdentityPoolResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
