/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to the UnlinkIdentity action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnlinkIdentityRequest extends CognitoIdentityRequest implements
        ToCopyableBuilder<UnlinkIdentityRequest.Builder, UnlinkIdentityRequest> {
    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityId").getter(getter(UnlinkIdentityRequest::identityId)).setter(setter(Builder::identityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityId").build()).build();

    private static final SdkField<Map<String, String>> LOGINS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Logins")
            .getter(getter(UnlinkIdentityRequest::logins))
            .setter(setter(Builder::logins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logins").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> LOGINS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LoginsToRemove")
            .getter(getter(UnlinkIdentityRequest::loginsToRemove))
            .setter(setter(Builder::loginsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoginsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_ID_FIELD,
            LOGINS_FIELD, LOGINS_TO_REMOVE_FIELD));

    private final String identityId;

    private final Map<String, String> logins;

    private final List<String> loginsToRemove;

    private UnlinkIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.identityId = builder.identityId;
        this.logins = builder.logins;
        this.loginsToRemove = builder.loginsToRemove;
    }

    /**
     * <p>
     * A unique identifier in the format REGION:GUID.
     * </p>
     * 
     * @return A unique identifier in the format REGION:GUID.
     */
    public final String identityId() {
        return identityId;
    }

    /**
     * Returns true if the Logins property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLogins() {
        return logins != null && !(logins instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of optional name-value pairs that map provider names to provider tokens.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLogins()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A set of optional name-value pairs that map provider names to provider tokens.
     */
    public final Map<String, String> logins() {
        return logins;
    }

    /**
     * Returns true if the LoginsToRemove property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLoginsToRemove() {
        return loginsToRemove != null && !(loginsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provider names to unlink from this identity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLoginsToRemove()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Provider names to unlink from this identity.
     */
    public final List<String> loginsToRemove() {
        return loginsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityId());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogins() ? logins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLoginsToRemove() ? loginsToRemove() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnlinkIdentityRequest)) {
            return false;
        }
        UnlinkIdentityRequest other = (UnlinkIdentityRequest) obj;
        return Objects.equals(identityId(), other.identityId()) && hasLogins() == other.hasLogins()
                && Objects.equals(logins(), other.logins()) && hasLoginsToRemove() == other.hasLoginsToRemove()
                && Objects.equals(loginsToRemove(), other.loginsToRemove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnlinkIdentityRequest").add("IdentityId", identityId())
                .add("Logins", hasLogins() ? logins() : null)
                .add("LoginsToRemove", hasLoginsToRemove() ? loginsToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityId":
            return Optional.ofNullable(clazz.cast(identityId()));
        case "Logins":
            return Optional.ofNullable(clazz.cast(logins()));
        case "LoginsToRemove":
            return Optional.ofNullable(clazz.cast(loginsToRemove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnlinkIdentityRequest, T> g) {
        return obj -> g.apply((UnlinkIdentityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityRequest.Builder, SdkPojo, CopyableBuilder<Builder, UnlinkIdentityRequest> {
        /**
         * <p>
         * A unique identifier in the format REGION:GUID.
         * </p>
         * 
         * @param identityId
         *        A unique identifier in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * A set of optional name-value pairs that map provider names to provider tokens.
         * </p>
         * 
         * @param logins
         *        A set of optional name-value pairs that map provider names to provider tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logins(Map<String, String> logins);

        /**
         * <p>
         * Provider names to unlink from this identity.
         * </p>
         * 
         * @param loginsToRemove
         *        Provider names to unlink from this identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loginsToRemove(Collection<String> loginsToRemove);

        /**
         * <p>
         * Provider names to unlink from this identity.
         * </p>
         * 
         * @param loginsToRemove
         *        Provider names to unlink from this identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loginsToRemove(String... loginsToRemove);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityRequest.BuilderImpl implements Builder {
        private String identityId;

        private Map<String, String> logins = DefaultSdkAutoConstructMap.getInstance();

        private List<String> loginsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UnlinkIdentityRequest model) {
            super(model);
            identityId(model.identityId);
            logins(model.logins);
            loginsToRemove(model.loginsToRemove);
        }

        public final String getIdentityId() {
            return identityId;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        @Override
        @Transient
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final Map<String, String> getLogins() {
            if (logins instanceof SdkAutoConstructMap) {
                return null;
            }
            return logins;
        }

        public final void setLogins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
        }

        @Override
        @Transient
        public final Builder logins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
            return this;
        }

        public final Collection<String> getLoginsToRemove() {
            if (loginsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return loginsToRemove;
        }

        public final void setLoginsToRemove(Collection<String> loginsToRemove) {
            this.loginsToRemove = LoginsListCopier.copy(loginsToRemove);
        }

        @Override
        @Transient
        public final Builder loginsToRemove(Collection<String> loginsToRemove) {
            this.loginsToRemove = LoginsListCopier.copy(loginsToRemove);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder loginsToRemove(String... loginsToRemove) {
            loginsToRemove(Arrays.asList(loginsToRemove));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UnlinkIdentityRequest build() {
            return new UnlinkIdentityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
