/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for rules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RulesConfigurationType implements SdkPojo, Serializable,
        ToCopyableBuilder<RulesConfigurationType.Builder, RulesConfigurationType> {
    private static final SdkField<List<MappingRule>> RULES_FIELD = SdkField
            .<List<MappingRule>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(RulesConfigurationType::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MappingRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(MappingRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<MappingRule> rules;

    private RulesConfigurationType(BuilderImpl builder) {
        this.rules = builder.rules;
    }

    /**
     * Returns true if the Rules property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of rules. You can specify up to 25 rules per identity provider.
     * </p>
     * <p>
     * Rules are evaluated in order. The first one to match specifies the role.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of rules. You can specify up to 25 rules per identity provider.</p>
     *         <p>
     *         Rules are evaluated in order. The first one to match specifies the role.
     */
    public final List<MappingRule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RulesConfigurationType)) {
            return false;
        }
        RulesConfigurationType other = (RulesConfigurationType) obj;
        return hasRules() == other.hasRules() && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RulesConfigurationType").add("Rules", hasRules() ? rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RulesConfigurationType, T> g) {
        return obj -> g.apply((RulesConfigurationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RulesConfigurationType> {
        /**
         * <p>
         * An array of rules. You can specify up to 25 rules per identity provider.
         * </p>
         * <p>
         * Rules are evaluated in order. The first one to match specifies the role.
         * </p>
         * 
         * @param rules
         *        An array of rules. You can specify up to 25 rules per identity provider.</p>
         *        <p>
         *        Rules are evaluated in order. The first one to match specifies the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<MappingRule> rules);

        /**
         * <p>
         * An array of rules. You can specify up to 25 rules per identity provider.
         * </p>
         * <p>
         * Rules are evaluated in order. The first one to match specifies the role.
         * </p>
         * 
         * @param rules
         *        An array of rules. You can specify up to 25 rules per identity provider.</p>
         *        <p>
         *        Rules are evaluated in order. The first one to match specifies the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(MappingRule... rules);

        /**
         * <p>
         * An array of rules. You can specify up to 25 rules per identity provider.
         * </p>
         * <p>
         * Rules are evaluated in order. The first one to match specifies the role.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MappingRule>.Builder} avoiding the need to
         * create one manually via {@link List<MappingRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MappingRule>.Builder#build()} is called immediately and its
         * result is passed to {@link #rules(List<MappingRule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on {@link List<MappingRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(List<MappingRule>)
         */
        Builder rules(Consumer<MappingRule.Builder>... rules);
    }

    static final class BuilderImpl implements Builder {
        private List<MappingRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RulesConfigurationType model) {
            rules(model.rules);
        }

        public final List<MappingRule.Builder> getRules() {
            List<MappingRule.Builder> result = MappingRulesListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder rules(Collection<MappingRule> rules) {
            this.rules = MappingRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(MappingRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<MappingRule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> MappingRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<MappingRule.BuilderImpl> rules) {
            this.rules = MappingRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public RulesConfigurationType build() {
            return new RulesConfigurationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
