/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.IdentityIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteIdentitiesRequest
extends CognitoIdentityRequest
implements ToCopyableBuilder<Builder, DeleteIdentitiesRequest> {
    private static final SdkField<List<String>> IDENTITY_IDS_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IdentityIdsToDelete").getter(DeleteIdentitiesRequest.getter(DeleteIdentitiesRequest::identityIdsToDelete)).setter(DeleteIdentitiesRequest.setter(Builder::identityIdsToDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityIdsToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_IDS_TO_DELETE_FIELD));
    private final List<String> identityIdsToDelete;

    private DeleteIdentitiesRequest(BuilderImpl builder) {
        super(builder);
        this.identityIdsToDelete = builder.identityIdsToDelete;
    }

    public final boolean hasIdentityIdsToDelete() {
        return this.identityIdsToDelete != null && !(this.identityIdsToDelete instanceof SdkAutoConstructList);
    }

    public final List<String> identityIdsToDelete() {
        return this.identityIdsToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentityIdsToDelete() ? this.identityIdsToDelete() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIdentitiesRequest)) {
            return false;
        }
        DeleteIdentitiesRequest other = (DeleteIdentitiesRequest)((Object)obj);
        return this.hasIdentityIdsToDelete() == other.hasIdentityIdsToDelete() && Objects.equals(this.identityIdsToDelete(), other.identityIdsToDelete());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteIdentitiesRequest").add("IdentityIdsToDelete", this.hasIdentityIdsToDelete() ? this.identityIdsToDelete() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityIdsToDelete": {
                return Optional.ofNullable(clazz.cast(this.identityIdsToDelete()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteIdentitiesRequest, T> g) {
        return obj -> g.apply((DeleteIdentitiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityRequest.BuilderImpl
    implements Builder {
        private List<String> identityIdsToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIdentitiesRequest model) {
            super(model);
            this.identityIdsToDelete(model.identityIdsToDelete);
        }

        public final Collection<String> getIdentityIdsToDelete() {
            if (this.identityIdsToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return this.identityIdsToDelete;
        }

        public final void setIdentityIdsToDelete(Collection<String> identityIdsToDelete) {
            this.identityIdsToDelete = IdentityIdListCopier.copy(identityIdsToDelete);
        }

        @Override
        public final Builder identityIdsToDelete(Collection<String> identityIdsToDelete) {
            this.identityIdsToDelete = IdentityIdListCopier.copy(identityIdsToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityIdsToDelete(String ... identityIdsToDelete) {
            this.identityIdsToDelete(Arrays.asList(identityIdsToDelete));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteIdentitiesRequest build() {
            return new DeleteIdentitiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteIdentitiesRequest> {
        public Builder identityIdsToDelete(Collection<String> var1);

        public Builder identityIdsToDelete(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

