/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPrincipalTagAttributeMapResponse extends CognitoIdentityResponse implements
        ToCopyableBuilder<GetPrincipalTagAttributeMapResponse.Builder, GetPrincipalTagAttributeMapResponse> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityPoolId").getter(getter(GetPrincipalTagAttributeMapResponse::identityPoolId))
            .setter(setter(Builder::identityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()).build();

    private static final SdkField<String> IDENTITY_PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityProviderName").getter(getter(GetPrincipalTagAttributeMapResponse::identityProviderName))
            .setter(setter(Builder::identityProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderName").build())
            .build();

    private static final SdkField<Boolean> USE_DEFAULTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseDefaults").getter(getter(GetPrincipalTagAttributeMapResponse::useDefaults))
            .setter(setter(Builder::useDefaults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseDefaults").build()).build();

    private static final SdkField<Map<String, String>> PRINCIPAL_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("PrincipalTags")
            .getter(getter(GetPrincipalTagAttributeMapResponse::principalTags))
            .setter(setter(Builder::principalTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD,
            IDENTITY_PROVIDER_NAME_FIELD, USE_DEFAULTS_FIELD, PRINCIPAL_TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("IdentityPoolId", IDENTITY_POOL_ID_FIELD);
                    put("IdentityProviderName", IDENTITY_PROVIDER_NAME_FIELD);
                    put("UseDefaults", USE_DEFAULTS_FIELD);
                    put("PrincipalTags", PRINCIPAL_TAGS_FIELD);
                }
            });

    private final String identityPoolId;

    private final String identityProviderName;

    private final Boolean useDefaults;

    private final Map<String, String> principalTags;

    private GetPrincipalTagAttributeMapResponse(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identityProviderName = builder.identityProviderName;
        this.useDefaults = builder.useDefaults;
        this.principalTags = builder.principalTags;
    }

    /**
     * <p>
     * You can use this operation to get the ID of the Identity Pool you setup attribute mappings for.
     * </p>
     * 
     * @return You can use this operation to get the ID of the Identity Pool you setup attribute mappings for.
     */
    public final String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * You can use this operation to get the provider name.
     * </p>
     * 
     * @return You can use this operation to get the provider name.
     */
    public final String identityProviderName() {
        return identityProviderName;
    }

    /**
     * <p>
     * You can use this operation to list
     * </p>
     * 
     * @return You can use this operation to list
     */
    public final Boolean useDefaults() {
        return useDefaults;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrincipalTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrincipalTags() {
        return principalTags != null && !(principalTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * You can use this operation to add principal tags. The <code>PrincipalTags</code>operation enables you to
     * reference user attributes in your IAM permissions policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrincipalTags} method.
     * </p>
     * 
     * @return You can use this operation to add principal tags. The <code>PrincipalTags</code>operation enables you to
     *         reference user attributes in your IAM permissions policy.
     */
    public final Map<String, String> principalTags() {
        return principalTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(useDefaults());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrincipalTags() ? principalTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPrincipalTagAttributeMapResponse)) {
            return false;
        }
        GetPrincipalTagAttributeMapResponse other = (GetPrincipalTagAttributeMapResponse) obj;
        return Objects.equals(identityPoolId(), other.identityPoolId())
                && Objects.equals(identityProviderName(), other.identityProviderName())
                && Objects.equals(useDefaults(), other.useDefaults()) && hasPrincipalTags() == other.hasPrincipalTags()
                && Objects.equals(principalTags(), other.principalTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPrincipalTagAttributeMapResponse").add("IdentityPoolId", identityPoolId())
                .add("IdentityProviderName", identityProviderName()).add("UseDefaults", useDefaults())
                .add("PrincipalTags", hasPrincipalTags() ? principalTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPoolId":
            return Optional.ofNullable(clazz.cast(identityPoolId()));
        case "IdentityProviderName":
            return Optional.ofNullable(clazz.cast(identityProviderName()));
        case "UseDefaults":
            return Optional.ofNullable(clazz.cast(useDefaults()));
        case "PrincipalTags":
            return Optional.ofNullable(clazz.cast(principalTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetPrincipalTagAttributeMapResponse, T> g) {
        return obj -> g.apply((GetPrincipalTagAttributeMapResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPrincipalTagAttributeMapResponse> {
        /**
         * <p>
         * You can use this operation to get the ID of the Identity Pool you setup attribute mappings for.
         * </p>
         * 
         * @param identityPoolId
         *        You can use this operation to get the ID of the Identity Pool you setup attribute mappings for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * You can use this operation to get the provider name.
         * </p>
         * 
         * @param identityProviderName
         *        You can use this operation to get the provider name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderName(String identityProviderName);

        /**
         * <p>
         * You can use this operation to list
         * </p>
         * 
         * @param useDefaults
         *        You can use this operation to list
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useDefaults(Boolean useDefaults);

        /**
         * <p>
         * You can use this operation to add principal tags. The <code>PrincipalTags</code>operation enables you to
         * reference user attributes in your IAM permissions policy.
         * </p>
         * 
         * @param principalTags
         *        You can use this operation to add principal tags. The <code>PrincipalTags</code>operation enables you
         *        to reference user attributes in your IAM permissions policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalTags(Map<String, String> principalTags);
    }

    static final class BuilderImpl extends CognitoIdentityResponse.BuilderImpl implements Builder {
        private String identityPoolId;

        private String identityProviderName;

        private Boolean useDefaults;

        private Map<String, String> principalTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPrincipalTagAttributeMapResponse model) {
            super(model);
            identityPoolId(model.identityPoolId);
            identityProviderName(model.identityProviderName);
            useDefaults(model.useDefaults);
            principalTags(model.principalTags);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final String getIdentityProviderName() {
            return identityProviderName;
        }

        public final void setIdentityProviderName(String identityProviderName) {
            this.identityProviderName = identityProviderName;
        }

        @Override
        public final Builder identityProviderName(String identityProviderName) {
            this.identityProviderName = identityProviderName;
            return this;
        }

        public final Boolean getUseDefaults() {
            return useDefaults;
        }

        public final void setUseDefaults(Boolean useDefaults) {
            this.useDefaults = useDefaults;
        }

        @Override
        public final Builder useDefaults(Boolean useDefaults) {
            this.useDefaults = useDefaults;
            return this;
        }

        public final Map<String, String> getPrincipalTags() {
            if (principalTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return principalTags;
        }

        public final void setPrincipalTags(Map<String, String> principalTags) {
            this.principalTags = PrincipalTagsCopier.copy(principalTags);
        }

        @Override
        public final Builder principalTags(Map<String, String> principalTags) {
            this.principalTags = PrincipalTagsCopier.copy(principalTags);
            return this;
        }

        @Override
        public GetPrincipalTagAttributeMapResponse build() {
            return new GetPrincipalTagAttributeMapResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
