/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rule that maps a claim name, a claim value, and a match type to a role ARN.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MappingRule implements SdkPojo, Serializable, ToCopyableBuilder<MappingRule.Builder, MappingRule> {
    private static final SdkField<String> CLAIM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Claim")
            .getter(getter(MappingRule::claim)).setter(setter(Builder::claim))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Claim").build()).build();

    private static final SdkField<String> MATCH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MatchType").getter(getter(MappingRule::matchTypeAsString)).setter(setter(Builder::matchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchType").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(MappingRule::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(MappingRule::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLAIM_FIELD, MATCH_TYPE_FIELD,
            VALUE_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Claim", CLAIM_FIELD);
                    put("MatchType", MATCH_TYPE_FIELD);
                    put("Value", VALUE_FIELD);
                    put("RoleARN", ROLE_ARN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String claim;

    private final String matchType;

    private final String value;

    private final String roleARN;

    private MappingRule(BuilderImpl builder) {
        this.claim = builder.claim;
        this.matchType = builder.matchType;
        this.value = builder.value;
        this.roleARN = builder.roleARN;
    }

    /**
     * <p>
     * The claim name that must be present in the token, for example, "isAdmin" or "paid".
     * </p>
     * 
     * @return The claim name that must be present in the token, for example, "isAdmin" or "paid".
     */
    public final String claim() {
        return claim;
    }

    /**
     * <p>
     * The match condition that specifies how closely the claim value in the IdP token must match <code>Value</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchType} will
     * return {@link MappingRuleMatchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #matchTypeAsString}.
     * </p>
     * 
     * @return The match condition that specifies how closely the claim value in the IdP token must match
     *         <code>Value</code>.
     * @see MappingRuleMatchType
     */
    public final MappingRuleMatchType matchType() {
        return MappingRuleMatchType.fromValue(matchType);
    }

    /**
     * <p>
     * The match condition that specifies how closely the claim value in the IdP token must match <code>Value</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchType} will
     * return {@link MappingRuleMatchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #matchTypeAsString}.
     * </p>
     * 
     * @return The match condition that specifies how closely the claim value in the IdP token must match
     *         <code>Value</code>.
     * @see MappingRuleMatchType
     */
    public final String matchTypeAsString() {
        return matchType;
    }

    /**
     * <p>
     * A brief string that the claim must match, for example, "paid" or "yes".
     * </p>
     * 
     * @return A brief string that the claim must match, for example, "paid" or "yes".
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The role ARN.
     * </p>
     * 
     * @return The role ARN.
     */
    public final String roleARN() {
        return roleARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(claim());
        hashCode = 31 * hashCode + Objects.hashCode(matchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MappingRule)) {
            return false;
        }
        MappingRule other = (MappingRule) obj;
        return Objects.equals(claim(), other.claim()) && Objects.equals(matchTypeAsString(), other.matchTypeAsString())
                && Objects.equals(value(), other.value()) && Objects.equals(roleARN(), other.roleARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MappingRule").add("Claim", claim()).add("MatchType", matchTypeAsString()).add("Value", value())
                .add("RoleARN", roleARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Claim":
            return Optional.ofNullable(clazz.cast(claim()));
        case "MatchType":
            return Optional.ofNullable(clazz.cast(matchTypeAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MappingRule, T> g) {
        return obj -> g.apply((MappingRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MappingRule> {
        /**
         * <p>
         * The claim name that must be present in the token, for example, "isAdmin" or "paid".
         * </p>
         * 
         * @param claim
         *        The claim name that must be present in the token, for example, "isAdmin" or "paid".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder claim(String claim);

        /**
         * <p>
         * The match condition that specifies how closely the claim value in the IdP token must match <code>Value</code>
         * .
         * </p>
         * 
         * @param matchType
         *        The match condition that specifies how closely the claim value in the IdP token must match
         *        <code>Value</code>.
         * @see MappingRuleMatchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MappingRuleMatchType
         */
        Builder matchType(String matchType);

        /**
         * <p>
         * The match condition that specifies how closely the claim value in the IdP token must match <code>Value</code>
         * .
         * </p>
         * 
         * @param matchType
         *        The match condition that specifies how closely the claim value in the IdP token must match
         *        <code>Value</code>.
         * @see MappingRuleMatchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MappingRuleMatchType
         */
        Builder matchType(MappingRuleMatchType matchType);

        /**
         * <p>
         * A brief string that the claim must match, for example, "paid" or "yes".
         * </p>
         * 
         * @param value
         *        A brief string that the claim must match, for example, "paid" or "yes".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The role ARN.
         * </p>
         * 
         * @param roleARN
         *        The role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);
    }

    static final class BuilderImpl implements Builder {
        private String claim;

        private String matchType;

        private String value;

        private String roleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(MappingRule model) {
            claim(model.claim);
            matchType(model.matchType);
            value(model.value);
            roleARN(model.roleARN);
        }

        public final String getClaim() {
            return claim;
        }

        public final void setClaim(String claim) {
            this.claim = claim;
        }

        @Override
        public final Builder claim(String claim) {
            this.claim = claim;
            return this;
        }

        public final String getMatchType() {
            return matchType;
        }

        public final void setMatchType(String matchType) {
            this.matchType = matchType;
        }

        @Override
        public final Builder matchType(String matchType) {
            this.matchType = matchType;
            return this;
        }

        @Override
        public final Builder matchType(MappingRuleMatchType matchType) {
            this.matchType(matchType == null ? null : matchType.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        @Override
        public MappingRule build() {
            return new MappingRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
