/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.LoginsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCredentialsForIdentityRequest
extends CognitoIdentityRequest
implements ToCopyableBuilder<Builder, GetCredentialsForIdentityRequest> {
    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityId").getter(GetCredentialsForIdentityRequest.getter(GetCredentialsForIdentityRequest::identityId)).setter(GetCredentialsForIdentityRequest.setter(Builder::identityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityId").build()}).build();
    private static final SdkField<Map<String, String>> LOGINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Logins").getter(GetCredentialsForIdentityRequest.getter(GetCredentialsForIdentityRequest::logins)).setter(GetCredentialsForIdentityRequest.setter(Builder::logins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logins").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CUSTOM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomRoleArn").getter(GetCredentialsForIdentityRequest.getter(GetCredentialsForIdentityRequest::customRoleArn)).setter(GetCredentialsForIdentityRequest.setter(Builder::customRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_ID_FIELD, LOGINS_FIELD, CUSTOM_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("IdentityId", IDENTITY_ID_FIELD);
            this.put("Logins", LOGINS_FIELD);
            this.put("CustomRoleArn", CUSTOM_ROLE_ARN_FIELD);
        }
    });
    private final String identityId;
    private final Map<String, String> logins;
    private final String customRoleArn;

    private GetCredentialsForIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.identityId = builder.identityId;
        this.logins = builder.logins;
        this.customRoleArn = builder.customRoleArn;
    }

    public final String identityId() {
        return this.identityId;
    }

    public final boolean hasLogins() {
        return this.logins != null && !(this.logins instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> logins() {
        return this.logins;
    }

    public final String customRoleArn() {
        return this.customRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogins() ? this.logins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.customRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCredentialsForIdentityRequest)) {
            return false;
        }
        GetCredentialsForIdentityRequest other = (GetCredentialsForIdentityRequest)((Object)obj);
        return Objects.equals(this.identityId(), other.identityId()) && this.hasLogins() == other.hasLogins() && Objects.equals(this.logins(), other.logins()) && Objects.equals(this.customRoleArn(), other.customRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetCredentialsForIdentityRequest").add("IdentityId", (Object)this.identityId()).add("Logins", (Object)(this.logins() == null ? null : "*** Sensitive Data Redacted ***")).add("CustomRoleArn", (Object)this.customRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityId": {
                return Optional.ofNullable(clazz.cast(this.identityId()));
            }
            case "Logins": {
                return Optional.ofNullable(clazz.cast(this.logins()));
            }
            case "CustomRoleArn": {
                return Optional.ofNullable(clazz.cast(this.customRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetCredentialsForIdentityRequest, T> g) {
        return obj -> g.apply((GetCredentialsForIdentityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityRequest.BuilderImpl
    implements Builder {
        private String identityId;
        private Map<String, String> logins = DefaultSdkAutoConstructMap.getInstance();
        private String customRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCredentialsForIdentityRequest model) {
            super(model);
            this.identityId(model.identityId);
            this.logins(model.logins);
            this.customRoleArn(model.customRoleArn);
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final Map<String, String> getLogins() {
            if (this.logins instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.logins;
        }

        public final void setLogins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
        }

        @Override
        public final Builder logins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
            return this;
        }

        public final String getCustomRoleArn() {
            return this.customRoleArn;
        }

        public final void setCustomRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
        }

        @Override
        public final Builder customRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCredentialsForIdentityRequest build() {
            return new GetCredentialsForIdentityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCredentialsForIdentityRequest> {
        public Builder identityId(String var1);

        public Builder logins(Map<String, String> var1);

        public Builder customRoleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

