/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A provider representing an Amazon Cognito Identity User Pool and its client ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CognitoIdentityProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<CognitoIdentityProvider.Builder, CognitoIdentityProvider> {
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CognitoIdentityProvider::providerName)).setter(setter(Builder::providerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderName").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CognitoIdentityProvider::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<Boolean> SERVER_SIDE_TOKEN_CHECK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CognitoIdentityProvider::serverSideTokenCheck)).setter(setter(Builder::serverSideTokenCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideTokenCheck").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_NAME_FIELD,
            CLIENT_ID_FIELD, SERVER_SIDE_TOKEN_CHECK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String providerName;

    private final String clientId;

    private final Boolean serverSideTokenCheck;

    private CognitoIdentityProvider(BuilderImpl builder) {
        this.providerName = builder.providerName;
        this.clientId = builder.clientId;
        this.serverSideTokenCheck = builder.serverSideTokenCheck;
    }

    /**
     * <p>
     * The provider name for an Amazon Cognito Identity User Pool. For example,
     * <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.
     * </p>
     * 
     * @return The provider name for an Amazon Cognito Identity User Pool. For example,
     *         <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.
     */
    public String providerName() {
        return providerName;
    }

    /**
     * <p>
     * The client ID for the Amazon Cognito Identity User Pool.
     * </p>
     * 
     * @return The client ID for the Amazon Cognito Identity User Pool.
     */
    public String clientId() {
        return clientId;
    }

    /**
     * <p>
     * TRUE if server-side token validation is enabled for the identity provider’s token.
     * </p>
     * 
     * @return TRUE if server-side token validation is enabled for the identity provider’s token.
     */
    public Boolean serverSideTokenCheck() {
        return serverSideTokenCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(providerName());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideTokenCheck());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoIdentityProvider)) {
            return false;
        }
        CognitoIdentityProvider other = (CognitoIdentityProvider) obj;
        return Objects.equals(providerName(), other.providerName()) && Objects.equals(clientId(), other.clientId())
                && Objects.equals(serverSideTokenCheck(), other.serverSideTokenCheck());
    }

    @Override
    public String toString() {
        return ToString.builder("CognitoIdentityProvider").add("ProviderName", providerName()).add("ClientId", clientId())
                .add("ServerSideTokenCheck", serverSideTokenCheck()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProviderName":
            return Optional.ofNullable(clazz.cast(providerName()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "ServerSideTokenCheck":
            return Optional.ofNullable(clazz.cast(serverSideTokenCheck()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CognitoIdentityProvider, T> g) {
        return obj -> g.apply((CognitoIdentityProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CognitoIdentityProvider> {
        /**
         * <p>
         * The provider name for an Amazon Cognito Identity User Pool. For example,
         * <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.
         * </p>
         * 
         * @param providerName
         *        The provider name for an Amazon Cognito Identity User Pool. For example,
         *        <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * The client ID for the Amazon Cognito Identity User Pool.
         * </p>
         * 
         * @param clientId
         *        The client ID for the Amazon Cognito Identity User Pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * TRUE if server-side token validation is enabled for the identity provider’s token.
         * </p>
         * 
         * @param serverSideTokenCheck
         *        TRUE if server-side token validation is enabled for the identity provider’s token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideTokenCheck(Boolean serverSideTokenCheck);
    }

    static final class BuilderImpl implements Builder {
        private String providerName;

        private String clientId;

        private Boolean serverSideTokenCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(CognitoIdentityProvider model) {
            providerName(model.providerName);
            clientId(model.clientId);
            serverSideTokenCheck(model.serverSideTokenCheck);
        }

        public final String getProviderName() {
            return providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final Boolean getServerSideTokenCheck() {
            return serverSideTokenCheck;
        }

        @Override
        public final Builder serverSideTokenCheck(Boolean serverSideTokenCheck) {
            this.serverSideTokenCheck = serverSideTokenCheck;
            return this;
        }

        public final void setServerSideTokenCheck(Boolean serverSideTokenCheck) {
            this.serverSideTokenCheck = serverSideTokenCheck;
        }

        @Override
        public CognitoIdentityProvider build() {
            return new CognitoIdentityProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
