/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to the <code>DeleteIdentities</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteIdentitiesRequest extends CognitoIdentityRequest implements
        ToCopyableBuilder<DeleteIdentitiesRequest.Builder, DeleteIdentitiesRequest> {
    private static final SdkField<List<String>> IDENTITY_IDS_TO_DELETE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DeleteIdentitiesRequest::identityIdsToDelete))
            .setter(setter(Builder::identityIdsToDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityIdsToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_IDS_TO_DELETE_FIELD));

    private final List<String> identityIdsToDelete;

    private DeleteIdentitiesRequest(BuilderImpl builder) {
        super(builder);
        this.identityIdsToDelete = builder.identityIdsToDelete;
    }

    /**
     * <p>
     * A list of 1-60 identities that you want to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of 1-60 identities that you want to delete.
     */
    public List<String> identityIdsToDelete() {
        return identityIdsToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityIdsToDelete());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIdentitiesRequest)) {
            return false;
        }
        DeleteIdentitiesRequest other = (DeleteIdentitiesRequest) obj;
        return Objects.equals(identityIdsToDelete(), other.identityIdsToDelete());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteIdentitiesRequest").add("IdentityIdsToDelete", identityIdsToDelete()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityIdsToDelete":
            return Optional.ofNullable(clazz.cast(identityIdsToDelete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteIdentitiesRequest, T> g) {
        return obj -> g.apply((DeleteIdentitiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteIdentitiesRequest> {
        /**
         * <p>
         * A list of 1-60 identities that you want to delete.
         * </p>
         * 
         * @param identityIdsToDelete
         *        A list of 1-60 identities that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityIdsToDelete(Collection<String> identityIdsToDelete);

        /**
         * <p>
         * A list of 1-60 identities that you want to delete.
         * </p>
         * 
         * @param identityIdsToDelete
         *        A list of 1-60 identities that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityIdsToDelete(String... identityIdsToDelete);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityRequest.BuilderImpl implements Builder {
        private List<String> identityIdsToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIdentitiesRequest model) {
            super(model);
            identityIdsToDelete(model.identityIdsToDelete);
        }

        public final Collection<String> getIdentityIdsToDelete() {
            return identityIdsToDelete;
        }

        @Override
        public final Builder identityIdsToDelete(Collection<String> identityIdsToDelete) {
            this.identityIdsToDelete = IdentityIdListCopier.copy(identityIdsToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityIdsToDelete(String... identityIdsToDelete) {
            identityIdsToDelete(Arrays.asList(identityIdsToDelete));
            return this;
        }

        public final void setIdentityIdsToDelete(Collection<String> identityIdsToDelete) {
            this.identityIdsToDelete = IdentityIdListCopier.copy(identityIdsToDelete);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteIdentitiesRequest build() {
            return new DeleteIdentitiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
