/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returned in response to a successful <code>DeleteIdentities</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteIdentitiesResponse extends CognitoIdentityResponse implements
        ToCopyableBuilder<DeleteIdentitiesResponse.Builder, DeleteIdentitiesResponse> {
    private static final SdkField<List<UnprocessedIdentityId>> UNPROCESSED_IDENTITY_IDS_FIELD = SdkField
            .<List<UnprocessedIdentityId>> builder(MarshallingType.LIST)
            .getter(getter(DeleteIdentitiesResponse::unprocessedIdentityIds))
            .setter(setter(Builder::unprocessedIdentityIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedIdentityIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedIdentityId> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedIdentityId::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(UNPROCESSED_IDENTITY_IDS_FIELD));

    private final List<UnprocessedIdentityId> unprocessedIdentityIds;

    private DeleteIdentitiesResponse(BuilderImpl builder) {
        super(builder);
        this.unprocessedIdentityIds = builder.unprocessedIdentityIds;
    }

    /**
     * <p>
     * An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and IdentityId.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and IdentityId.
     */
    public List<UnprocessedIdentityId> unprocessedIdentityIds() {
        return unprocessedIdentityIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unprocessedIdentityIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIdentitiesResponse)) {
            return false;
        }
        DeleteIdentitiesResponse other = (DeleteIdentitiesResponse) obj;
        return Objects.equals(unprocessedIdentityIds(), other.unprocessedIdentityIds());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteIdentitiesResponse").add("UnprocessedIdentityIds", unprocessedIdentityIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UnprocessedIdentityIds":
            return Optional.ofNullable(clazz.cast(unprocessedIdentityIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteIdentitiesResponse, T> g) {
        return obj -> g.apply((DeleteIdentitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteIdentitiesResponse> {
        /**
         * <p>
         * An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and IdentityId.
         * </p>
         * 
         * @param unprocessedIdentityIds
         *        An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and IdentityId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedIdentityIds(Collection<UnprocessedIdentityId> unprocessedIdentityIds);

        /**
         * <p>
         * An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and IdentityId.
         * </p>
         * 
         * @param unprocessedIdentityIds
         *        An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and IdentityId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedIdentityIds(UnprocessedIdentityId... unprocessedIdentityIds);

        /**
         * <p>
         * An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and IdentityId.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UnprocessedIdentityId>.Builder} avoiding
         * the need to create one manually via {@link List<UnprocessedIdentityId>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UnprocessedIdentityId>.Builder#build()} is called
         * immediately and its result is passed to {@link #unprocessedIdentityIds(List<UnprocessedIdentityId>)}.
         * 
         * @param unprocessedIdentityIds
         *        a consumer that will call methods on {@link List<UnprocessedIdentityId>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedIdentityIds(List<UnprocessedIdentityId>)
         */
        Builder unprocessedIdentityIds(Consumer<UnprocessedIdentityId.Builder>... unprocessedIdentityIds);
    }

    static final class BuilderImpl extends CognitoIdentityResponse.BuilderImpl implements Builder {
        private List<UnprocessedIdentityId> unprocessedIdentityIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIdentitiesResponse model) {
            super(model);
            unprocessedIdentityIds(model.unprocessedIdentityIds);
        }

        public final Collection<UnprocessedIdentityId.Builder> getUnprocessedIdentityIds() {
            return unprocessedIdentityIds != null ? unprocessedIdentityIds.stream().map(UnprocessedIdentityId::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedIdentityIds(Collection<UnprocessedIdentityId> unprocessedIdentityIds) {
            this.unprocessedIdentityIds = UnprocessedIdentityIdListCopier.copy(unprocessedIdentityIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedIdentityIds(UnprocessedIdentityId... unprocessedIdentityIds) {
            unprocessedIdentityIds(Arrays.asList(unprocessedIdentityIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedIdentityIds(Consumer<UnprocessedIdentityId.Builder>... unprocessedIdentityIds) {
            unprocessedIdentityIds(Stream.of(unprocessedIdentityIds)
                    .map(c -> UnprocessedIdentityId.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedIdentityIds(Collection<UnprocessedIdentityId.BuilderImpl> unprocessedIdentityIds) {
            this.unprocessedIdentityIds = UnprocessedIdentityIdListCopier.copyFromBuilder(unprocessedIdentityIds);
        }

        @Override
        public DeleteIdentitiesResponse build() {
            return new DeleteIdentitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
