/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A provider representing an Amazon Cognito user pool and its client ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CognitoIdentityProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<CognitoIdentityProvider.Builder, CognitoIdentityProvider> {
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderName").getter(getter(CognitoIdentityProvider::providerName))
            .setter(setter(Builder::providerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderName").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientId").getter(getter(CognitoIdentityProvider::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<Boolean> SERVER_SIDE_TOKEN_CHECK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ServerSideTokenCheck").getter(getter(CognitoIdentityProvider::serverSideTokenCheck))
            .setter(setter(Builder::serverSideTokenCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideTokenCheck").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_NAME_FIELD,
            CLIENT_ID_FIELD, SERVER_SIDE_TOKEN_CHECK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String providerName;

    private final String clientId;

    private final Boolean serverSideTokenCheck;

    private CognitoIdentityProvider(BuilderImpl builder) {
        this.providerName = builder.providerName;
        this.clientId = builder.clientId;
        this.serverSideTokenCheck = builder.serverSideTokenCheck;
    }

    /**
     * <p>
     * The provider name for an Amazon Cognito user pool. For example,
     * <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.
     * </p>
     * 
     * @return The provider name for an Amazon Cognito user pool. For example,
     *         <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.
     */
    public final String providerName() {
        return providerName;
    }

    /**
     * <p>
     * The client ID for the Amazon Cognito user pool.
     * </p>
     * 
     * @return The client ID for the Amazon Cognito user pool.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * TRUE if server-side token validation is enabled for the identity provider’s token.
     * </p>
     * <p>
     * Once you set <code>ServerSideTokenCheck</code> to TRUE for an identity pool, that identity pool will check with
     * the integrated user pools to make sure that the user has not been globally signed out or deleted before the
     * identity pool provides an OIDC token or Amazon Web Services credentials for the user.
     * </p>
     * <p>
     * If the user is signed out or deleted, the identity pool will return a 400 Not Authorized error.
     * </p>
     * 
     * @return TRUE if server-side token validation is enabled for the identity provider’s token.</p>
     *         <p>
     *         Once you set <code>ServerSideTokenCheck</code> to TRUE for an identity pool, that identity pool will
     *         check with the integrated user pools to make sure that the user has not been globally signed out or
     *         deleted before the identity pool provides an OIDC token or Amazon Web Services credentials for the user.
     *         </p>
     *         <p>
     *         If the user is signed out or deleted, the identity pool will return a 400 Not Authorized error.
     */
    public final Boolean serverSideTokenCheck() {
        return serverSideTokenCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(providerName());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideTokenCheck());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoIdentityProvider)) {
            return false;
        }
        CognitoIdentityProvider other = (CognitoIdentityProvider) obj;
        return Objects.equals(providerName(), other.providerName()) && Objects.equals(clientId(), other.clientId())
                && Objects.equals(serverSideTokenCheck(), other.serverSideTokenCheck());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CognitoIdentityProvider").add("ProviderName", providerName()).add("ClientId", clientId())
                .add("ServerSideTokenCheck", serverSideTokenCheck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProviderName":
            return Optional.ofNullable(clazz.cast(providerName()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "ServerSideTokenCheck":
            return Optional.ofNullable(clazz.cast(serverSideTokenCheck()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProviderName", PROVIDER_NAME_FIELD);
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("ServerSideTokenCheck", SERVER_SIDE_TOKEN_CHECK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CognitoIdentityProvider, T> g) {
        return obj -> g.apply((CognitoIdentityProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CognitoIdentityProvider> {
        /**
         * <p>
         * The provider name for an Amazon Cognito user pool. For example,
         * <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.
         * </p>
         * 
         * @param providerName
         *        The provider name for an Amazon Cognito user pool. For example,
         *        <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * The client ID for the Amazon Cognito user pool.
         * </p>
         * 
         * @param clientId
         *        The client ID for the Amazon Cognito user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * TRUE if server-side token validation is enabled for the identity provider’s token.
         * </p>
         * <p>
         * Once you set <code>ServerSideTokenCheck</code> to TRUE for an identity pool, that identity pool will check
         * with the integrated user pools to make sure that the user has not been globally signed out or deleted before
         * the identity pool provides an OIDC token or Amazon Web Services credentials for the user.
         * </p>
         * <p>
         * If the user is signed out or deleted, the identity pool will return a 400 Not Authorized error.
         * </p>
         * 
         * @param serverSideTokenCheck
         *        TRUE if server-side token validation is enabled for the identity provider’s token.</p>
         *        <p>
         *        Once you set <code>ServerSideTokenCheck</code> to TRUE for an identity pool, that identity pool will
         *        check with the integrated user pools to make sure that the user has not been globally signed out or
         *        deleted before the identity pool provides an OIDC token or Amazon Web Services credentials for the
         *        user.
         *        </p>
         *        <p>
         *        If the user is signed out or deleted, the identity pool will return a 400 Not Authorized error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideTokenCheck(Boolean serverSideTokenCheck);
    }

    static final class BuilderImpl implements Builder {
        private String providerName;

        private String clientId;

        private Boolean serverSideTokenCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(CognitoIdentityProvider model) {
            providerName(model.providerName);
            clientId(model.clientId);
            serverSideTokenCheck(model.serverSideTokenCheck);
        }

        public final String getProviderName() {
            return providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final Boolean getServerSideTokenCheck() {
            return serverSideTokenCheck;
        }

        public final void setServerSideTokenCheck(Boolean serverSideTokenCheck) {
            this.serverSideTokenCheck = serverSideTokenCheck;
        }

        @Override
        public final Builder serverSideTokenCheck(Boolean serverSideTokenCheck) {
            this.serverSideTokenCheck = serverSideTokenCheck;
            return this;
        }

        @Override
        public CognitoIdentityProvider build() {
            return new CognitoIdentityProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
