/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to the GetId action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIdRequest extends CognitoIdentityRequest implements ToCopyableBuilder<GetIdRequest.Builder, GetIdRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(GetIdRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityPoolId").getter(getter(GetIdRequest::identityPoolId)).setter(setter(Builder::identityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()).build();

    private static final SdkField<Map<String, String>> LOGINS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Logins")
            .getter(getter(GetIdRequest::logins))
            .setter(setter(Builder::logins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logins").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            IDENTITY_POOL_ID_FIELD, LOGINS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final String identityPoolId;

    private final Map<String, String> logins;

    private GetIdRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.identityPoolId = builder.identityPoolId;
        this.logins = builder.logins;
    }

    /**
     * <p>
     * A standard Amazon Web Services account ID (9+ digits).
     * </p>
     * 
     * @return A standard Amazon Web Services account ID (9+ digits).
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * An identity pool ID in the format REGION:GUID.
     * </p>
     * 
     * @return An identity pool ID in the format REGION:GUID.
     */
    public final String identityPoolId() {
        return identityPoolId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Logins property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLogins() {
        return logins != null && !(logins instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of optional name-value pairs that map provider names to provider tokens. The available provider names for
     * <code>Logins</code> are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Facebook: <code>graph.facebook.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito user pool: <code>cognito-idp.&lt;region&gt;.amazonaws.com/&lt;YOUR_USER_POOL_ID&gt;</code>, for
     * example, <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Google: <code>accounts.google.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon: <code>www.amazon.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Twitter: <code>api.twitter.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Digits: <code>www.digits.com</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogins} method.
     * </p>
     * 
     * @return A set of optional name-value pairs that map provider names to provider tokens. The available provider
     *         names for <code>Logins</code> are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Facebook: <code>graph.facebook.com</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Cognito user pool: <code>cognito-idp.&lt;region&gt;.amazonaws.com/&lt;YOUR_USER_POOL_ID&gt;</code>
     *         , for example, <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Google: <code>accounts.google.com</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon: <code>www.amazon.com</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Twitter: <code>api.twitter.com</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Digits: <code>www.digits.com</code>
     *         </p>
     *         </li>
     */
    public final Map<String, String> logins() {
        return logins;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogins() ? logins() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdRequest)) {
            return false;
        }
        GetIdRequest other = (GetIdRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(identityPoolId(), other.identityPoolId())
                && hasLogins() == other.hasLogins() && Objects.equals(logins(), other.logins());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIdRequest").add("AccountId", accountId()).add("IdentityPoolId", identityPoolId())
                .add("Logins", logins() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "IdentityPoolId":
            return Optional.ofNullable(clazz.cast(identityPoolId()));
        case "Logins":
            return Optional.ofNullable(clazz.cast(logins()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("IdentityPoolId", IDENTITY_POOL_ID_FIELD);
        map.put("Logins", LOGINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIdRequest, T> g) {
        return obj -> g.apply((GetIdRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetIdRequest> {
        /**
         * <p>
         * A standard Amazon Web Services account ID (9+ digits).
         * </p>
         * 
         * @param accountId
         *        A standard Amazon Web Services account ID (9+ digits).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * An identity pool ID in the format REGION:GUID.
         * </p>
         * 
         * @param identityPoolId
         *        An identity pool ID in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * A set of optional name-value pairs that map provider names to provider tokens. The available provider names
         * for <code>Logins</code> are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Facebook: <code>graph.facebook.com</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Cognito user pool: <code>cognito-idp.&lt;region&gt;.amazonaws.com/&lt;YOUR_USER_POOL_ID&gt;</code>,
         * for example, <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Google: <code>accounts.google.com</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon: <code>www.amazon.com</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Twitter: <code>api.twitter.com</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Digits: <code>www.digits.com</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param logins
         *        A set of optional name-value pairs that map provider names to provider tokens. The available provider
         *        names for <code>Logins</code> are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Facebook: <code>graph.facebook.com</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Cognito user pool:
         *        <code>cognito-idp.&lt;region&gt;.amazonaws.com/&lt;YOUR_USER_POOL_ID&gt;</code>, for example,
         *        <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Google: <code>accounts.google.com</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon: <code>www.amazon.com</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Twitter: <code>api.twitter.com</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Digits: <code>www.digits.com</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logins(Map<String, String> logins);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityRequest.BuilderImpl implements Builder {
        private String accountId;

        private String identityPoolId;

        private Map<String, String> logins = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdRequest model) {
            super(model);
            accountId(model.accountId);
            identityPoolId(model.identityPoolId);
            logins(model.logins);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final Map<String, String> getLogins() {
            if (logins instanceof SdkAutoConstructMap) {
                return null;
            }
            return logins;
        }

        public final void setLogins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
        }

        @Override
        public final Builder logins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIdRequest build() {
            return new GetIdRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
