/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returned in response to a successful GetOpenIdToken request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOpenIdTokenResponse extends CognitoIdentityResponse implements
        ToCopyableBuilder<GetOpenIdTokenResponse.Builder, GetOpenIdTokenResponse> {
    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetOpenIdTokenResponse::identityId)).setter(setter(Builder::identityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityId").build()).build();

    private static final SdkField<String> TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetOpenIdTokenResponse::token)).setter(setter(Builder::token))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Token").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IDENTITY_ID_FIELD, TOKEN_FIELD));

    private final String identityId;

    private final String token;

    private GetOpenIdTokenResponse(BuilderImpl builder) {
        super(builder);
        this.identityId = builder.identityId;
        this.token = builder.token;
    }

    /**
     * <p>
     * A unique identifier in the format REGION:GUID. Note that the IdentityId returned may not match the one passed on
     * input.
     * </p>
     * 
     * @return A unique identifier in the format REGION:GUID. Note that the IdentityId returned may not match the one
     *         passed on input.
     */
    public String identityId() {
        return identityId;
    }

    /**
     * <p>
     * An OpenID token, valid for 15 minutes.
     * </p>
     * 
     * @return An OpenID token, valid for 15 minutes.
     */
    public String token() {
        return token;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityId());
        hashCode = 31 * hashCode + Objects.hashCode(token());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpenIdTokenResponse)) {
            return false;
        }
        GetOpenIdTokenResponse other = (GetOpenIdTokenResponse) obj;
        return Objects.equals(identityId(), other.identityId()) && Objects.equals(token(), other.token());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetOpenIdTokenResponse").add("IdentityId", identityId()).add("Token", token()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityId":
            return Optional.ofNullable(clazz.cast(identityId()));
        case "Token":
            return Optional.ofNullable(clazz.cast(token()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOpenIdTokenResponse, T> g) {
        return obj -> g.apply((GetOpenIdTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetOpenIdTokenResponse> {
        /**
         * <p>
         * A unique identifier in the format REGION:GUID. Note that the IdentityId returned may not match the one passed
         * on input.
         * </p>
         * 
         * @param identityId
         *        A unique identifier in the format REGION:GUID. Note that the IdentityId returned may not match the one
         *        passed on input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * An OpenID token, valid for 15 minutes.
         * </p>
         * 
         * @param token
         *        An OpenID token, valid for 15 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);
    }

    static final class BuilderImpl extends CognitoIdentityResponse.BuilderImpl implements Builder {
        private String identityId;

        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpenIdTokenResponse model) {
            super(model);
            identityId(model.identityId);
            token(model.token);
        }

        public final String getIdentityId() {
            return identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getToken() {
            return token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public GetOpenIdTokenResponse build() {
            return new GetOpenIdTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
