/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A description of the identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIdentityResponse extends CognitoIdentityResponse implements
        ToCopyableBuilder<DescribeIdentityResponse.Builder, DescribeIdentityResponse> {
    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeIdentityResponse::identityId)).setter(setter(Builder::identityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityId").build()).build();

    private static final SdkField<List<String>> LOGINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeIdentityResponse::logins))
            .setter(setter(Builder::logins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logins").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeIdentityResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeIdentityResponse::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_ID_FIELD,
            LOGINS_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));

    private final String identityId;

    private final List<String> logins;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private DescribeIdentityResponse(BuilderImpl builder) {
        super(builder);
        this.identityId = builder.identityId;
        this.logins = builder.logins;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * A unique identifier in the format REGION:GUID.
     * </p>
     * 
     * @return A unique identifier in the format REGION:GUID.
     */
    public String identityId() {
        return identityId;
    }

    /**
     * <p>
     * The provider names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The provider names.
     */
    public List<String> logins() {
        return logins;
    }

    /**
     * <p>
     * Date on which the identity was created.
     * </p>
     * 
     * @return Date on which the identity was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * Date on which the identity was last modified.
     * </p>
     * 
     * @return Date on which the identity was last modified.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityId());
        hashCode = 31 * hashCode + Objects.hashCode(logins());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdentityResponse)) {
            return false;
        }
        DescribeIdentityResponse other = (DescribeIdentityResponse) obj;
        return Objects.equals(identityId(), other.identityId()) && Objects.equals(logins(), other.logins())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeIdentityResponse").add("IdentityId", identityId()).add("Logins", logins())
                .add("CreationDate", creationDate()).add("LastModifiedDate", lastModifiedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityId":
            return Optional.ofNullable(clazz.cast(identityId()));
        case "Logins":
            return Optional.ofNullable(clazz.cast(logins()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIdentityResponse, T> g) {
        return obj -> g.apply((DescribeIdentityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeIdentityResponse> {
        /**
         * <p>
         * A unique identifier in the format REGION:GUID.
         * </p>
         * 
         * @param identityId
         *        A unique identifier in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * The provider names.
         * </p>
         * 
         * @param logins
         *        The provider names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logins(Collection<String> logins);

        /**
         * <p>
         * The provider names.
         * </p>
         * 
         * @param logins
         *        The provider names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logins(String... logins);

        /**
         * <p>
         * Date on which the identity was created.
         * </p>
         * 
         * @param creationDate
         *        Date on which the identity was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * Date on which the identity was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        Date on which the identity was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);
    }

    static final class BuilderImpl extends CognitoIdentityResponse.BuilderImpl implements Builder {
        private String identityId;

        private List<String> logins = DefaultSdkAutoConstructList.getInstance();

        private Instant creationDate;

        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdentityResponse model) {
            super(model);
            identityId(model.identityId);
            logins(model.logins);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final String getIdentityId() {
            return identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final Collection<String> getLogins() {
            return logins;
        }

        @Override
        public final Builder logins(Collection<String> logins) {
            this.logins = LoginsListCopier.copy(logins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logins(String... logins) {
            logins(Arrays.asList(logins));
            return this;
        }

        public final void setLogins(Collection<String> logins) {
            this.logins = LoginsListCopier.copy(logins);
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public DescribeIdentityResponse build() {
            return new DescribeIdentityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
